/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.ThreadMetadata;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.GlobalStreamThread;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.processor.internals.ThreadStateTransitionValidator;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.StreamsMetadata;
import org.apache.kafka.streams.state.internals.GlobalStateStoreProvider;
import org.apache.kafka.streams.state.internals.QueryableStoreProvider;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.StreamThreadStateStoreProvider;
import org.slf4j.Logger;

@InterfaceStability.Evolving
public class KafkaStreams {
    private static final String JMX_PREFIX = "kafka.streams";
    private static final int DEFAULT_CLOSE_TIMEOUT = 0;
    private final Time time;
    private final Logger log;
    private final UUID processId;
    private final String clientId;
    private final Metrics metrics;
    private final StreamsConfig config;
    private final StreamThread[] threads;
    private final StateDirectory stateDirectory;
    private final StreamsMetadataState streamsMetadataState;
    private final ScheduledExecutorService stateDirCleaner;
    private final QueryableStoreProvider queryableStoreProvider;
    private final AdminClient adminClient;
    private GlobalStreamThread globalStreamThread;
    private StateListener stateListener;
    private StateRestoreListener globalStateRestoreListener;
    private final Object stateLock = new Object();
    private volatile State state = State.CREATED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitOnState(State targetState, long waitMs) {
        long begin = this.time.milliseconds();
        Object object = this.stateLock;
        synchronized (object) {
            long elapsedMs = 0L;
            while (this.state != targetState) {
                if (waitMs == 0L) {
                    try {
                        this.stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (waitMs > elapsedMs) {
                    long remainingMs = waitMs - elapsedMs;
                    try {
                        this.stateLock.wait(remainingMs);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.log.debug("Cannot transit to {} within {}ms", (Object)targetState, (Object)waitMs);
                    return false;
                }
                elapsedMs = this.time.milliseconds() - begin;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setState(State newState) {
        State oldState = this.state;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.PENDING_SHUTDOWN && newState != State.NOT_RUNNING) {
                return false;
            }
            if (this.state == State.NOT_RUNNING && (newState == State.PENDING_SHUTDOWN || newState == State.NOT_RUNNING)) {
                return false;
            }
            if (!this.state.isValidTransition(newState)) {
                throw new IllegalStateException("Stream-client " + this.clientId + ": Unexpected state transition from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState));
            }
            this.log.info("State transition from {} to {}", (Object)oldState, (Object)newState);
            this.state = newState;
            this.stateLock.notifyAll();
        }
        if (this.stateListener != null) {
            this.stateListener.onChange(this.state, oldState);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRunningFromCreated() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.CREATED) {
                throw new IllegalStateException("Stream-client " + this.clientId + ": Unexpected state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)State.RUNNING));
            }
            this.state = State.RUNNING;
            this.stateLock.notifyAll();
        }
        if (this.stateListener != null) {
            this.stateListener.onChange(State.RUNNING, State.CREATED);
        }
        return true;
    }

    public State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunning() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.isRunning();
        }
    }

    private void validateIsRunning() {
        if (!this.isRunning()) {
            throw new IllegalStateException("KafkaStreams is not running. State is " + (Object)((Object)this.state) + ".");
        }
    }

    public void setStateListener(StateListener listener) {
        if (this.state != State.CREATED) {
            throw new IllegalStateException("Can only set StateListener in CREATED state. Current state is: " + (Object)((Object)this.state));
        }
        this.stateListener = listener;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler eh) {
        if (this.state == State.CREATED) {
            for (StreamThread thread : this.threads) {
                thread.setUncaughtExceptionHandler(eh);
            }
            if (this.globalStreamThread != null) {
                this.globalStreamThread.setUncaughtExceptionHandler(eh);
            }
        } else {
            throw new IllegalStateException("Can only set UncaughtExceptionHandler in CREATED state. Current state is: " + (Object)((Object)this.state));
        }
    }

    public void setGlobalStateRestoreListener(StateRestoreListener globalStateRestoreListener) {
        if (this.state != State.CREATED) {
            throw new IllegalStateException("Can only set GlobalStateRestoreListener in CREATED state. Current state is: " + (Object)((Object)this.state));
        }
        this.globalStateRestoreListener = globalStateRestoreListener;
    }

    public Map<MetricName, ? extends Metric> metrics() {
        LinkedHashMap<MetricName, Metric> result = new LinkedHashMap<MetricName, Metric>();
        for (StreamThread thread : this.threads) {
            result.putAll(thread.producerMetrics());
            result.putAll(thread.consumerMetrics());
        }
        if (this.globalStreamThread != null) {
            result.putAll(this.globalStreamThread.consumerMetrics());
        }
        result.putAll(this.metrics.metrics());
        return Collections.unmodifiableMap(result);
    }

    public KafkaStreams(Topology topology, Properties props) {
        this(topology.internalTopologyBuilder, new StreamsConfig(props), (KafkaClientSupplier)new DefaultKafkaClientSupplier());
    }

    public KafkaStreams(Topology topology, Properties props, KafkaClientSupplier clientSupplier) {
        this(topology.internalTopologyBuilder, new StreamsConfig(props), clientSupplier, Time.SYSTEM);
    }

    public KafkaStreams(Topology topology, Properties props, Time time) {
        this(topology.internalTopologyBuilder, new StreamsConfig(props), (KafkaClientSupplier)new DefaultKafkaClientSupplier(), time);
    }

    public KafkaStreams(Topology topology, Properties props, KafkaClientSupplier clientSupplier, Time time) {
        this(topology.internalTopologyBuilder, new StreamsConfig(props), clientSupplier, time);
    }

    @Deprecated
    public KafkaStreams(Topology topology, StreamsConfig config) {
        this(topology, config, (KafkaClientSupplier)new DefaultKafkaClientSupplier());
    }

    @Deprecated
    public KafkaStreams(Topology topology, StreamsConfig config, KafkaClientSupplier clientSupplier) {
        this(topology.internalTopologyBuilder, config, clientSupplier);
    }

    @Deprecated
    public KafkaStreams(Topology topology, StreamsConfig config, Time time) {
        this(topology.internalTopologyBuilder, config, (KafkaClientSupplier)new DefaultKafkaClientSupplier(), time);
    }

    private KafkaStreams(InternalTopologyBuilder internalTopologyBuilder, StreamsConfig config, KafkaClientSupplier clientSupplier) throws StreamsException {
        this(internalTopologyBuilder, config, clientSupplier, Time.SYSTEM);
    }

    private KafkaStreams(InternalTopologyBuilder internalTopologyBuilder, StreamsConfig config, KafkaClientSupplier clientSupplier, Time time) throws StreamsException {
        this.config = config;
        this.time = time;
        internalTopologyBuilder.adjust(config);
        this.processId = UUID.randomUUID();
        String userClientId = config.getString("client.id");
        String applicationId = config.getString("application.id");
        this.clientId = userClientId.length() <= 0 ? applicationId + "-" + this.processId : userClientId;
        LogContext logContext = new LogContext(String.format("stream-client [%s] ", this.clientId));
        this.log = logContext.logger(this.getClass());
        try {
            this.stateDirectory = new StateDirectory(config, time);
        }
        catch (ProcessorStateException fatal) {
            throw new StreamsException((Throwable)((Object)fatal));
        }
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples").intValue()).recordLevel(Sensor.RecordingLevel.forName((String)config.getString("metrics.recording.level"))).timeWindow(config.getLong("metrics.sample.window.ms").longValue(), TimeUnit.MILLISECONDS);
        List reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        reporters.add(new JmxReporter(JMX_PREFIX));
        this.metrics = new Metrics(metricConfig, reporters, time);
        internalTopologyBuilder.setApplicationId(applicationId);
        internalTopologyBuilder.build();
        this.streamsMetadataState = new StreamsMetadataState(internalTopologyBuilder, KafkaStreams.parseHostInfo(config.getString("application.server")));
        this.threads = new StreamThread[config.getInt("num.stream.threads").intValue()];
        long totalCacheSize = config.getLong("cache.max.bytes.buffering");
        if (totalCacheSize < 0L) {
            totalCacheSize = 0L;
            this.log.warn("Negative cache size passed in. Reverting to cache size of 0 bytes.");
        }
        ProcessorTopology globalTaskTopology = internalTopologyBuilder.buildGlobalStateTopology();
        long cacheSizePerThread = totalCacheSize / (long)(this.threads.length + (globalTaskTopology == null ? 0 : 1));
        DelegatingStateRestoreListener delegatingStateRestoreListener = new DelegatingStateRestoreListener();
        GlobalStreamThread.State globalThreadState = null;
        if (globalTaskTopology != null) {
            String globalThreadId = this.clientId + "-GlobalStreamThread";
            this.globalStreamThread = new GlobalStreamThread(globalTaskTopology, config, clientSupplier.getGlobalConsumer(config.getGlobalConsumerConfigs(this.clientId)), this.stateDirectory, cacheSizePerThread, this.metrics, time, globalThreadId, delegatingStateRestoreListener);
            globalThreadState = this.globalStreamThread.state();
        }
        this.adminClient = clientSupplier.getAdminClient(config.getAdminConfigs(this.clientId));
        HashMap<Long, StreamThread.State> threadState = new HashMap<Long, StreamThread.State>(this.threads.length);
        ArrayList<StateStoreProvider> storeProviders = new ArrayList<StateStoreProvider>();
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = StreamThread.create(internalTopologyBuilder, config, clientSupplier, this.adminClient, this.processId, this.clientId, this.metrics, time, this.streamsMetadataState, cacheSizePerThread, this.stateDirectory, delegatingStateRestoreListener);
            threadState.put(this.threads[i].getId(), this.threads[i].state());
            storeProviders.add(new StreamThreadStateStoreProvider(this.threads[i]));
        }
        StreamStateListener streamStateListener = new StreamStateListener(threadState, globalThreadState);
        if (globalTaskTopology != null) {
            this.globalStreamThread.setStateListener(streamStateListener);
        }
        for (StreamThread thread : this.threads) {
            thread.setStateListener(streamStateListener);
        }
        GlobalStateStoreProvider globalStateStoreProvider = new GlobalStateStoreProvider(internalTopologyBuilder.globalStateStores());
        this.queryableStoreProvider = new QueryableStoreProvider(storeProviders, globalStateStoreProvider);
        this.stateDirCleaner = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, KafkaStreams.this.clientId + "-CleanupThread");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    private static HostInfo parseHostInfo(String endPoint) {
        if (endPoint == null || endPoint.trim().isEmpty()) {
            return StreamsMetadataState.UNKNOWN_HOST;
        }
        String host = Utils.getHost((String)endPoint);
        Integer port = Utils.getPort((String)endPoint);
        if (host == null || port == null) {
            throw new ConfigException(String.format("Error parsing host address %s. Expected format host:port.", endPoint));
        }
        return new HostInfo(host, port);
    }

    public synchronized void start() throws IllegalStateException, StreamsException {
        this.log.debug("Starting Streams client");
        if (this.setRunningFromCreated()) {
            if (this.globalStreamThread != null) {
                this.globalStreamThread.start();
            }
            for (StreamThread thread : this.threads) {
                thread.start();
            }
            final Long cleanupDelay = this.config.getLong("state.cleanup.delay.ms");
            this.stateDirCleaner.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (KafkaStreams.this.state == State.RUNNING) {
                        KafkaStreams.this.stateDirectory.cleanRemovedTasks(cleanupDelay);
                    }
                }
            }, cleanupDelay, cleanupDelay, TimeUnit.MILLISECONDS);
            this.log.info("Started Streams client");
        } else {
            this.log.error("Already stopped, cannot re-start");
        }
    }

    public void close() {
        this.close(0L, TimeUnit.SECONDS);
    }

    public synchronized boolean close(long timeout, TimeUnit timeUnit) {
        this.log.debug("Stopping Streams client with timeoutMillis = {} ms.", (Object)timeUnit.toMillis(timeout));
        if (!this.setState(State.PENDING_SHUTDOWN)) {
            this.log.info("Already in the pending shutdown state, wait to complete shutdown");
        } else {
            this.stateDirCleaner.shutdownNow();
            Thread shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (StreamThread thread : KafkaStreams.this.threads) {
                        thread.setStateListener(null);
                        thread.shutdown();
                    }
                    for (StreamThread thread : KafkaStreams.this.threads) {
                        try {
                            if (thread.isRunning()) continue;
                            thread.join();
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (KafkaStreams.this.globalStreamThread != null) {
                        KafkaStreams.this.globalStreamThread.setStateListener(null);
                        KafkaStreams.this.globalStreamThread.shutdown();
                    }
                    if (KafkaStreams.this.globalStreamThread != null && !KafkaStreams.this.globalStreamThread.stillRunning()) {
                        try {
                            KafkaStreams.this.globalStreamThread.join();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        KafkaStreams.this.globalStreamThread = null;
                    }
                    KafkaStreams.this.adminClient.close();
                    KafkaStreams.this.metrics.close();
                    KafkaStreams.this.setState(State.NOT_RUNNING);
                }
            }, "kafka-streams-close-thread");
            shutdownThread.setDaemon(true);
            shutdownThread.start();
        }
        if (this.waitOnState(State.NOT_RUNNING, timeUnit.toMillis(timeout))) {
            this.log.info("Streams client stopped completely");
            return true;
        }
        this.log.info("Streams client cannot stop completely within the timeout");
        return false;
    }

    public void cleanUp() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot clean up while running.");
        }
        this.stateDirectory.clean();
    }

    public Collection<StreamsMetadata> allMetadata() {
        this.validateIsRunning();
        return this.streamsMetadataState.getAllMetadata();
    }

    public Collection<StreamsMetadata> allMetadataForStore(String storeName) {
        this.validateIsRunning();
        return this.streamsMetadataState.getAllMetadataForStore(storeName);
    }

    public <K> StreamsMetadata metadataForKey(String storeName, K key, Serializer<K> keySerializer) {
        this.validateIsRunning();
        return this.streamsMetadataState.getMetadataWithKey(storeName, key, keySerializer);
    }

    public <K> StreamsMetadata metadataForKey(String storeName, K key, StreamPartitioner<? super K, ?> partitioner) {
        this.validateIsRunning();
        return this.streamsMetadataState.getMetadataWithKey(storeName, key, partitioner);
    }

    public <T> T store(String storeName, QueryableStoreType<T> queryableStoreType) {
        this.validateIsRunning();
        return this.queryableStoreProvider.getStore(storeName, queryableStoreType);
    }

    public Set<ThreadMetadata> localThreadsMetadata() {
        this.validateIsRunning();
        HashSet<ThreadMetadata> threadMetadata = new HashSet<ThreadMetadata>();
        for (StreamThread thread : this.threads) {
            threadMetadata.add(thread.threadMetadata());
        }
        return threadMetadata;
    }

    final class DelegatingStateRestoreListener
    implements StateRestoreListener {
        DelegatingStateRestoreListener() {
        }

        private void throwOnFatalException(Exception fatalUserException, TopicPartition topicPartition, String storeName) {
            throw new StreamsException(String.format("Fatal user code error in store restore listener for store %s, partition %s.", storeName, topicPartition), fatalUserException);
        }

        @Override
        public void onRestoreStart(TopicPartition topicPartition, String storeName, long startingOffset, long endingOffset) {
            if (KafkaStreams.this.globalStateRestoreListener != null) {
                try {
                    KafkaStreams.this.globalStateRestoreListener.onRestoreStart(topicPartition, storeName, startingOffset, endingOffset);
                }
                catch (Exception fatalUserException) {
                    this.throwOnFatalException(fatalUserException, topicPartition, storeName);
                }
            }
        }

        @Override
        public void onBatchRestored(TopicPartition topicPartition, String storeName, long batchEndOffset, long numRestored) {
            if (KafkaStreams.this.globalStateRestoreListener != null) {
                try {
                    KafkaStreams.this.globalStateRestoreListener.onBatchRestored(topicPartition, storeName, batchEndOffset, numRestored);
                }
                catch (Exception fatalUserException) {
                    this.throwOnFatalException(fatalUserException, topicPartition, storeName);
                }
            }
        }

        @Override
        public void onRestoreEnd(TopicPartition topicPartition, String storeName, long totalRestored) {
            if (KafkaStreams.this.globalStateRestoreListener != null) {
                try {
                    KafkaStreams.this.globalStateRestoreListener.onRestoreEnd(topicPartition, storeName, totalRestored);
                }
                catch (Exception fatalUserException) {
                    this.throwOnFatalException(fatalUserException, topicPartition, storeName);
                }
            }
        }
    }

    final class StreamStateListener
    implements StreamThread.StateListener {
        private final Map<Long, StreamThread.State> threadState;
        private GlobalStreamThread.State globalThreadState;

        StreamStateListener(Map<Long, StreamThread.State> threadState, GlobalStreamThread.State globalThreadState) {
            this.threadState = threadState;
            this.globalThreadState = globalThreadState;
        }

        private void maybeSetError() {
            for (StreamThread.State state : this.threadState.values()) {
                if (state == StreamThread.State.DEAD) continue;
                return;
            }
            if (KafkaStreams.this.setState(State.ERROR)) {
                KafkaStreams.this.log.warn("All stream threads have died. The instance will be in error state and should be closed.");
            }
        }

        private void maybeSetRunning() {
            for (StreamThread.State state : this.threadState.values()) {
                if (state == StreamThread.State.RUNNING) continue;
                return;
            }
            if (this.globalThreadState != null && this.globalThreadState != GlobalStreamThread.State.RUNNING) {
                return;
            }
            KafkaStreams.this.setState(State.RUNNING);
        }

        @Override
        public synchronized void onChange(Thread thread, ThreadStateTransitionValidator abstractNewState, ThreadStateTransitionValidator abstractOldState) {
            if (thread instanceof StreamThread) {
                StreamThread.State newState = (StreamThread.State)abstractNewState;
                this.threadState.put(thread.getId(), newState);
                if (newState == StreamThread.State.PARTITIONS_REVOKED && KafkaStreams.this.state != State.REBALANCING) {
                    KafkaStreams.this.setState(State.REBALANCING);
                } else if (newState == StreamThread.State.RUNNING && KafkaStreams.this.state != State.RUNNING) {
                    this.maybeSetRunning();
                } else if (newState == StreamThread.State.DEAD && KafkaStreams.this.state != State.ERROR) {
                    this.maybeSetError();
                }
            } else if (thread instanceof GlobalStreamThread) {
                GlobalStreamThread.State newState;
                this.globalThreadState = newState = (GlobalStreamThread.State)abstractNewState;
                if (newState == GlobalStreamThread.State.DEAD && KafkaStreams.this.state != State.ERROR && KafkaStreams.this.setState(State.ERROR)) {
                    KafkaStreams.this.log.warn("Global thread has died. The instance will be in error state and should be closed.");
                }
            }
        }
    }

    public static interface StateListener {
        public void onChange(State var1, State var2);
    }

    public static enum State {
        CREATED(2, 3),
        REBALANCING(2, 3, 5),
        RUNNING(1, 3, 5),
        PENDING_SHUTDOWN(4),
        NOT_RUNNING(new Integer[0]),
        ERROR(3);

        private final Set<Integer> validTransitions = new HashSet<Integer>();

        private State(Integer ... validTransitions) {
            this.validTransitions.addAll(Arrays.asList(validTransitions));
        }

        public boolean isRunning() {
            return this.equals((Object)RUNNING) || this.equals((Object)REBALANCING);
        }

        public boolean isValidTransition(State newState) {
            return this.validTransitions.contains(newState.ordinal());
        }
    }
}

