/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import javax.ws.rs.core.UriBuilder;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.kafka.trogdor.rest.CreateWorkerRequest;
import org.apache.kafka.trogdor.rest.DestroyWorkerRequest;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.JsonRestServer;
import org.apache.kafka.trogdor.rest.StopWorkerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentClient {
    private final Logger log;
    private final int maxTries;
    private final String target;

    private AgentClient(Logger log, int maxTries, String target) {
        this.log = log;
        this.maxTries = maxTries;
        this.target = target;
    }

    public String target() {
        return this.target;
    }

    public int maxTries() {
        return this.maxTries;
    }

    private String url(String suffix) {
        return String.format("http://%s%s", this.target, suffix);
    }

    public AgentStatusResponse status() throws Exception {
        JsonRestServer.HttpResponse<AgentStatusResponse> resp = JsonRestServer.httpRequest(this.url("/agent/status"), "GET", null, new TypeReference<AgentStatusResponse>(){}, this.maxTries);
        return resp.body();
    }

    public void createWorker(CreateWorkerRequest request) throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.url("/agent/worker/create"), "POST", request, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public void stopWorker(StopWorkerRequest request) throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.url("/agent/worker/stop"), "PUT", request, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public void destroyWorker(DestroyWorkerRequest request) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.url("/agent/worker"));
        uriBuilder.queryParam("workerId", new Object[]{request.workerId()});
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(uriBuilder.build(new Object[0]).toString(), "DELETE", null, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public void invokeShutdown() throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.url("/agent/shutdown"), "PUT", null, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"trogdor-agent-client").defaultHelp(true).description("The Trogdor fault injection agent client.");
        parser.addArgument(new String[]{"target"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("target").metavar(new String[]{"TARGET"}).help("A colon-separated host and port pair.  For example, example.com:8888");
        MutuallyExclusiveGroup actions = parser.addMutuallyExclusiveGroup();
        actions.addArgument(new String[]{"--status"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("status").help("Get agent status.");
        actions.addArgument(new String[]{"--create-worker"}).action((ArgumentAction)Arguments.store()).type(String.class).dest("create_worker").metavar(new String[]{"SPEC_JSON"}).help("Create a new fault.");
        actions.addArgument(new String[]{"--stop-worker"}).action((ArgumentAction)Arguments.store()).type(Long.class).dest("stop_worker").metavar(new String[]{"WORKER_ID"}).help("Stop a worker ID.");
        actions.addArgument(new String[]{"--destroy-worker"}).action((ArgumentAction)Arguments.store()).type(Long.class).dest("destroy_worker").metavar(new String[]{"WORKER_ID"}).help("Destroy a worker ID.");
        actions.addArgument(new String[]{"--shutdown"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).dest("shutdown").help("Trigger agent shutdown");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit((int)0);
            }
            parser.handleError(e);
            Exit.exit((int)1);
        }
        String target = res.getString("target");
        AgentClient client = new Builder().maxTries(3).target(target).build();
        if (res.getBoolean("status").booleanValue()) {
            System.out.println("Got agent status: " + JsonUtil.toPrettyJsonString(client.status()));
        } else if (res.getString("create_worker") != null) {
            CreateWorkerRequest req = (CreateWorkerRequest)JsonUtil.JSON_SERDE.readValue(res.getString("create_worker"), CreateWorkerRequest.class);
            client.createWorker(req);
            System.out.printf("Sent CreateWorkerRequest for worker %d%n.", req.workerId());
        } else if (res.getString("stop_worker") != null) {
            long workerId = res.getLong("stop_worker");
            client.stopWorker(new StopWorkerRequest(workerId));
            System.out.printf("Sent StopWorkerRequest for worker %d%n.", workerId);
        } else if (res.getString("destroy_worker") != null) {
            long workerId = res.getLong("stop_worker");
            client.destroyWorker(new DestroyWorkerRequest(workerId));
            System.out.printf("Sent DestroyWorkerRequest for worker %d%n.", workerId);
        } else if (res.getBoolean("shutdown").booleanValue()) {
            client.invokeShutdown();
            System.out.println("Sent ShutdownRequest.");
        } else {
            System.out.println("You must choose an action. Type --help for help.");
            Exit.exit((int)1);
        }
    }

    public static class Builder {
        private Logger log = LoggerFactory.getLogger(AgentClient.class);
        private int maxTries = 1;
        private String target = null;

        public Builder log(Logger log) {
            this.log = log;
            return this;
        }

        public Builder maxTries(int maxTries) {
            this.maxTries = maxTries;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder target(String host, int port) {
            this.target = String.format("%s:%d", host, port);
            return this;
        }

        public AgentClient build() {
            if (this.target == null) {
                throw new RuntimeException("You must specify a target.");
            }
            return new AgentClient(this.log, this.maxTries, this.target);
        }
    }
}

