/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public final class WorkerUtils {
    private static final int ADMIN_REQUEST_TIMEOUT = 25000;
    private static final int CREATE_TOPICS_CALL_TIMEOUT = 180000;
    private static final int MAX_CREATE_TOPICS_BATCH_SIZE = 10;

    public static void abort(Logger log, String what, Throwable exception, KafkaFutureImpl<String> doneFuture) throws KafkaException {
        log.warn("{} caught an exception: ", (Object)what, (Object)exception);
        doneFuture.complete((Object)exception.getMessage());
        throw new KafkaException(exception);
    }

    public static int perSecToPerPeriod(float perSec, long periodMs) {
        float period = (float)periodMs / 1000.0f;
        float perPeriod = perSec * period;
        perPeriod = Math.max(1.0f, perPeriod);
        return (int)perPeriod;
    }

    public static void addConfigsToProperties(Properties props, Map<String, String> commonConf, Map<String, String> clientConf) {
        for (Map.Entry<String, String> commonEntry : commonConf.entrySet()) {
            props.setProperty(commonEntry.getKey(), commonEntry.getValue());
        }
        for (Map.Entry<String, String> entry : clientConf.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public static void createTopics(Logger log, String bootstrapServers, Map<String, String> commonClientConf, Map<String, String> adminClientConf, Map<String, NewTopic> topics, boolean failOnExisting) throws Throwable {
        try (AdminClient adminClient = WorkerUtils.createAdminClient(bootstrapServers, commonClientConf, adminClientConf);){
            WorkerUtils.createTopics(log, adminClient, topics, failOnExisting);
        }
        catch (Exception e) {
            log.warn("Failed to create or verify topics {}", topics, (Object)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<TopicPartition> getMatchingTopicPartitions(Logger log, String bootstrapServers, Map<String, String> commonClientConf, Map<String, String> adminClientConf, String topicRegex, int startPartition, int endPartition) throws Throwable {
        try (AdminClient adminClient = WorkerUtils.createAdminClient(bootstrapServers, commonClientConf, adminClientConf);){
            Collection<TopicPartition> collection = WorkerUtils.getMatchingTopicPartitions(adminClient, topicRegex, startPartition, endPartition);
            return collection;
        }
        catch (Exception e) {
            log.warn("Failed to get topic partitions matching {}", (Object)topicRegex, (Object)e);
            throw e;
        }
    }

    static void createTopics(Logger log, AdminClient adminClient, Map<String, NewTopic> topics, boolean failOnExisting) throws Throwable {
        if (topics.isEmpty()) {
            log.warn("Request to create topics has an empty topic list.");
            return;
        }
        Collection<String> topicsExists = WorkerUtils.createTopics(log, adminClient, topics.values());
        if (!topicsExists.isEmpty()) {
            if (failOnExisting) {
                log.warn("Topic(s) {} already exist.", topicsExists);
                throw new TopicExistsException("One or more topics already exist.");
            }
            WorkerUtils.verifyTopics(log, adminClient, topicsExists, topics);
        }
    }

    private static Collection<String> createTopics(Logger log, AdminClient adminClient, Collection<NewTopic> topics) throws Throwable {
        ArrayList<String> existingTopics;
        block9: {
            long startMs = Time.SYSTEM.milliseconds();
            int tries = 0;
            existingTopics = new ArrayList<String>();
            HashMap<String, NewTopic> newTopics = new HashMap<String, NewTopic>();
            for (NewTopic newTopic : topics) {
                newTopics.put(newTopic.name(), newTopic);
            }
            ArrayList topicsToCreate = new ArrayList(newTopics.keySet());
            do {
                String topicName;
                log.info("Attempting to create {} topics (try {})...", (Object)topicsToCreate.size(), (Object)(++tries));
                HashMap creations = new HashMap();
                while (!topicsToCreate.isEmpty()) {
                    ArrayList newTopicsBatch = new ArrayList();
                    for (int i = 0; i < 10 && !topicsToCreate.isEmpty(); ++i) {
                        topicName = (String)topicsToCreate.remove(0);
                        newTopicsBatch.add(newTopics.get(topicName));
                    }
                    creations.putAll(adminClient.createTopics((Collection)newTopicsBatch).values());
                }
                for (Map.Entry entry : creations.entrySet()) {
                    topicName = (String)entry.getKey();
                    Future future = (Future)entry.getValue();
                    try {
                        future.get();
                        log.debug("Successfully created {}.", (Object)topicName);
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof TimeoutException || e.getCause() instanceof NotEnoughReplicasException) {
                            log.warn("Attempt to create topic `{}` failed: {}", (Object)topicName, (Object)e.getCause().getMessage());
                            topicsToCreate.add(topicName);
                            continue;
                        }
                        if (e.getCause() instanceof TopicExistsException) {
                            log.info("Topic {} already exists.", (Object)topicName);
                            existingTopics.add(topicName);
                            continue;
                        }
                        log.warn("Failed to create {}", (Object)topicName, (Object)e.getCause());
                        throw e.getCause();
                    }
                }
                if (topicsToCreate.isEmpty()) break block9;
            } while (Time.SYSTEM.milliseconds() <= startMs + 180000L);
            String str = "Unable to create topic(s): " + Utils.join(topicsToCreate, (String)", ") + "after " + tries + " attempt(s)";
            log.warn(str);
            throw new TimeoutException(str);
        }
        return existingTopics;
    }

    private static void verifyTopics(Logger log, AdminClient adminClient, Collection<String> topicsToVerify, Map<String, NewTopic> topicsInfo) throws Throwable {
        DescribeTopicsResult topicsResult = adminClient.describeTopics(topicsToVerify, new DescribeTopicsOptions().timeoutMs(Integer.valueOf(25000)));
        Map topicDescriptionMap = (Map)topicsResult.all().get();
        for (TopicDescription desc : topicDescriptionMap.values()) {
            int partitions = topicsInfo.get(desc.name()).numPartitions();
            if (desc.partitions().size() == partitions) continue;
            String str = "Topic '" + desc.name() + "' exists, but has " + desc.partitions().size() + " partitions, while requested " + " number of partitions is " + partitions;
            log.warn(str);
            throw new RuntimeException(str);
        }
    }

    static Collection<TopicPartition> getMatchingTopicPartitions(AdminClient adminClient, String topicRegex, int startPartition, int endPartition) throws Throwable {
        Pattern topicNamePattern = Pattern.compile(topicRegex);
        ArrayList matchedTopics = new ArrayList();
        ListTopicsResult res = adminClient.listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(25000)));
        Map topicListingMap = (Map)res.namesToListings().get();
        for (Map.Entry topicListingEntry : topicListingMap.entrySet()) {
            if (((TopicListing)topicListingEntry.getValue()).isInternal() || !topicNamePattern.matcher((CharSequence)topicListingEntry.getKey()).matches()) continue;
            matchedTopics.add(topicListingEntry.getKey());
        }
        ArrayList<TopicPartition> out = new ArrayList<TopicPartition>();
        DescribeTopicsResult topicsResult = adminClient.describeTopics(matchedTopics, new DescribeTopicsOptions().timeoutMs(Integer.valueOf(25000)));
        Map topicDescriptionMap = (Map)topicsResult.all().get();
        for (TopicDescription desc : topicDescriptionMap.values()) {
            List partitions = desc.partitions();
            for (TopicPartitionInfo info : partitions) {
                if (info.partition() < startPartition || info.partition() > endPartition) continue;
                out.add(new TopicPartition(desc.name(), info.partition()));
            }
        }
        return out;
    }

    private static AdminClient createAdminClient(String bootstrapServers, Map<String, String> commonClientConf, Map<String, String> adminClientConf) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrapServers);
        props.put("request.timeout.ms", (Object)25000);
        WorkerUtils.addConfigsToProperties(props, commonClientConf, adminClientConf);
        return AdminClient.create((Properties)props);
    }
}

