/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.ThreadUtils;
import org.apache.kafka.trogdor.rest.ErrorResponse;
import org.apache.kafka.trogdor.rest.RestExceptionMapper;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRestServer {
    private static final Logger log = LoggerFactory.getLogger(JsonRestServer.class);
    private static final long GRACEFUL_SHUTDOWN_TIMEOUT_MS = 100L;
    private final ScheduledExecutorService shutdownExecutor = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory("JsonRestServerCleanupExecutor", false));
    private final Server jettyServer = new Server();
    private final ServerConnector connector = new ServerConnector(this.jettyServer);

    public JsonRestServer(int port) {
        if (port > 0) {
            this.connector.setPort(port);
        }
        this.jettyServer.setConnectors(new Connector[]{this.connector});
    }

    public void start(Object ... resources) {
        log.info("Starting REST server");
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)new JacksonJsonProvider(JsonUtil.JSON_SERDE));
        for (Object resource : resources) {
            resourceConfig.register(resource);
            log.info("Registered resource {}", resource);
        }
        resourceConfig.register(RestExceptionMapper.class);
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        ServletHolder servletHolder = new ServletHolder((Servlet)servletContainer);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(servletHolder, "/*");
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        Slf4jRequestLog requestLog = new Slf4jRequestLog();
        requestLog.setLoggerName(JsonRestServer.class.getCanonicalName());
        requestLog.setLogLatency(true);
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{context, new DefaultHandler(), requestLogHandler});
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        this.jettyServer.setHandler((Handler)statsHandler);
        this.jettyServer.setStopTimeout(100L);
        this.jettyServer.setStopAtShutdown(true);
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start REST server", e);
        }
        log.info("REST server listening at " + this.jettyServer.getURI());
    }

    public int port() {
        return this.connector.getLocalPort();
    }

    public void beginShutdown() {
        if (!this.shutdownExecutor.isShutdown()) {
            this.shutdownExecutor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        log.info("Stopping REST server");
                        JsonRestServer.this.jettyServer.stop();
                        JsonRestServer.this.jettyServer.join();
                        log.info("REST server stopped");
                    }
                    catch (Exception e) {
                        log.error("Unable to stop REST server", (Throwable)e);
                    }
                    finally {
                        JsonRestServer.this.jettyServer.destroy();
                    }
                    JsonRestServer.this.shutdownExecutor.shutdown();
                    return null;
                }
            });
        }
    }

    public void waitForShutdown() throws InterruptedException {
        while (!this.shutdownExecutor.isShutdown()) {
            this.shutdownExecutor.awaitTermination(1L, TimeUnit.DAYS);
        }
    }

    public static <T> HttpResponse<T> httpRequest(String url, String method, Object requestBodyData, TypeReference<T> responseFormat) throws IOException {
        return JsonRestServer.httpRequest(log, url, method, requestBodyData, responseFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> HttpResponse<T> httpRequest(Logger logger, String url, String method, Object requestBodyData, TypeReference<T> responseFormat) throws IOException {
        HttpURLConnection connection = null;
        try {
            int responseCode;
            String serializedBody = requestBodyData == null ? null : JsonUtil.JSON_SERDE.writeValueAsString(requestBodyData);
            logger.debug("Sending {} with input {} to {}", new Object[]{method, serializedBody, url});
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod(method);
            connection.setRequestProperty("User-Agent", "kafka");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoInput(true);
            connection.setUseCaches(false);
            if (requestBodyData != null) {
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                os.write(serializedBody.getBytes(StandardCharsets.UTF_8));
                os.flush();
                os.close();
            }
            if ((responseCode = connection.getResponseCode()) == 204) {
                HttpResponse<Object> httpResponse = new HttpResponse<Object>(null, new ErrorResponse(responseCode, connection.getResponseMessage()));
                return httpResponse;
            }
            if (responseCode >= 200 && responseCode < 300) {
                InputStream is = connection.getInputStream();
                Object result = JsonUtil.JSON_SERDE.readValue(is, responseFormat);
                is.close();
                HttpResponse<Object> httpResponse = new HttpResponse<Object>(result, null);
                return httpResponse;
            }
            InputStream es = connection.getErrorStream();
            if (es == null) {
                HttpResponse<Object> result = new HttpResponse<Object>(null, new ErrorResponse(responseCode, ""));
                return result;
            }
            ErrorResponse error = (ErrorResponse)JsonUtil.JSON_SERDE.readValue(es, ErrorResponse.class);
            es.close();
            HttpResponse<Object> httpResponse = new HttpResponse<Object>(null, error);
            return httpResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static <T> HttpResponse<T> httpRequest(String url, String method, Object requestBodyData, TypeReference<T> responseFormat, int maxTries) throws IOException, InterruptedException {
        return JsonRestServer.httpRequest(log, url, method, requestBodyData, responseFormat, maxTries);
    }

    public static <T> HttpResponse<T> httpRequest(Logger logger, String url, String method, Object requestBodyData, TypeReference<T> responseFormat, int maxTries) throws IOException, InterruptedException {
        IOException exc = null;
        for (int tries = 0; tries < maxTries; ++tries) {
            if (tries > 0) {
                Thread.sleep(tries > 1 ? 10L : 2L);
            }
            try {
                return JsonRestServer.httpRequest(logger, url, method, requestBodyData, responseFormat);
            }
            catch (IOException e) {
                logger.info("{} {}: error: {}", new Object[]{method, url, e.getMessage()});
                exc = e;
                continue;
            }
        }
        throw exc;
    }

    public static class HttpResponse<T> {
        private final T body;
        private final ErrorResponse error;

        HttpResponse(T body, ErrorResponse error) {
            this.body = body;
            this.error = error;
        }

        public T body() throws Exception {
            if (this.error != null) {
                throw RestExceptionMapper.toException(this.error.code(), this.error.message());
            }
            return this.body;
        }

        public ErrorResponse error() {
            return this.error;
        }
    }
}

