/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.mirror.MirrorConnectorConfig;
import org.apache.kafka.connect.mirror.MirrorHeartbeatTask;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.apache.kafka.connect.mirror.Scheduler;
import org.apache.kafka.connect.source.SourceConnector;

public class MirrorHeartbeatConnector
extends SourceConnector {
    private MirrorConnectorConfig config;
    private Scheduler scheduler;

    public MirrorHeartbeatConnector() {
    }

    MirrorHeartbeatConnector(MirrorConnectorConfig config) {
        this.config = config;
    }

    public void start(Map<String, String> props) {
        this.config = new MirrorConnectorConfig(props);
        this.scheduler = new Scheduler(MirrorHeartbeatConnector.class, this.config.adminTimeout());
        this.scheduler.execute(this::createInternalTopics, "creating internal topics");
    }

    public void stop() {
        Utils.closeQuietly((AutoCloseable)this.scheduler, (String)"scheduler");
    }

    public Class<? extends Task> taskClass() {
        return MirrorHeartbeatTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (this.config.emitHeartbeatsInterval().isNegative()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.config.originalsStrings());
    }

    public ConfigDef config() {
        return MirrorConnectorConfig.CONNECTOR_CONFIG_DEF;
    }

    public String version() {
        return AppInfoParser.getVersion();
    }

    private void createInternalTopics() {
        MirrorUtils.createSinglePartitionCompactedTopic(this.config.heartbeatsTopic(), this.config.heartbeatsTopicReplicationFactor(), this.config.targetAdminConfig());
    }
}

