/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.processor.api.ContextualFixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.FixedKeyRecord;

class KStreamFlatMapValues<KIn, VIn, VOut>
implements FixedKeyProcessorSupplier<KIn, VIn, VOut> {
    private final ValueMapperWithKey<? super KIn, ? super VIn, ? extends Iterable<? extends VOut>> mapper;

    KStreamFlatMapValues(ValueMapperWithKey<? super KIn, ? super VIn, ? extends Iterable<? extends VOut>> mapper) {
        this.mapper = mapper;
    }

    @Override
    public FixedKeyProcessor<KIn, VIn, VOut> get() {
        return new KStreamFlatMapValuesProcessor();
    }

    private class KStreamFlatMapValuesProcessor
    extends ContextualFixedKeyProcessor<KIn, VIn, VOut> {
        private KStreamFlatMapValuesProcessor() {
        }

        @Override
        public void process(FixedKeyRecord<KIn, VIn> record) {
            Iterable newValues = (Iterable)KStreamFlatMapValues.this.mapper.apply(record.key(), record.value());
            for (Object v : newValues) {
                this.context().forward(record.withValue(v));
            }
        }
    }
}

