/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.enterprise;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import org.jboss.netty.channel.ChannelException;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.ClusterClientModule;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemLifecycleAdapter;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.StoreLogService;
import org.neo4j.server.Bootstrapper;

public class ArbiterBootstrapper
implements Bootstrapper,
AutoCloseable {
    private final LifeSupport life = new LifeSupport();
    private final Timer timer = new Timer(true);

    public final int start(File homeDir, Optional<File> configFile, Map<String, String> configOverrides) {
        Config config = ArbiterBootstrapper.getConfig(configFile, configOverrides);
        try {
            DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
            this.life.add((Lifecycle)new FileSystemLifecycleAdapter((FileSystemAbstraction)fileSystem));
            this.life.add((Lifecycle)JobSchedulerFactory.createScheduler());
            new ClusterClientModule(this.life, new Dependencies(), new Monitors(), config, ArbiterBootstrapper.logService((FileSystemAbstraction)fileSystem, config), (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider());
        }
        catch (LifecycleException e) {
            Throwable cause = Exceptions.peel((Throwable)e, (Predicate)Predicates.instanceOf(LifecycleException.class));
            if (cause instanceof ChannelException) {
                System.err.println("ERROR: " + cause.getMessage() + (cause.getCause() != null ? ", caused by:" + cause.getCause().getMessage() : ""));
            }
            System.err.println("ERROR: Unknown error");
            throw e;
        }
        this.addShutdownHook();
        this.life.start();
        return 0;
    }

    public int stop() {
        this.life.shutdown();
        return 0;
    }

    @Override
    public void close() {
        this.stop();
    }

    private static Config getConfig(Optional<File> configFile, Map<String, String> configOverrides) {
        Config config = Config.builder().withFile(configFile).withSettings(configOverrides).build();
        ArbiterBootstrapper.verifyConfig(config.getRaw());
        return config;
    }

    private static void verifyConfig(Map<String, String> config) {
        if (!config.containsKey(ClusterSettings.initial_hosts.name())) {
            throw new IllegalArgumentException("No initial hosts to connect to supplied");
        }
        if (!config.containsKey(ClusterSettings.server_id.name())) {
            throw new IllegalArgumentException("No server id specified");
        }
    }

    private static LogService logService(FileSystemAbstraction fileSystem, Config config) {
        File logFile = (File)config.get(GraphDatabaseSettings.store_internal_log_path);
        try {
            ZoneId zoneId = ((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId();
            FormattedLogProvider logProvider = FormattedLogProvider.withZoneId((ZoneId)zoneId).toOutputStream((OutputStream)System.out);
            return StoreLogService.withUserLogProvider((LogProvider)logProvider).withInternalLog(logFile).build(fileSystem);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    System.err.println("Failed to stop in a reasonable time, terminating...");
                    Runtime.getRuntime().halt(1);
                }
            }, 4000L);
            this.stop();
        }));
    }
}

