/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.CoreDatabaseAvailabilityService;
import org.neo4j.server.rest.MasterInfoService;
import org.neo4j.server.rest.ReadReplicaDatabaseAvailabilityService;
import org.neo4j.server.rest.causalclustering.CausalClusteringService;
import org.neo4j.server.web.WebServer;

public class DatabaseRoleInfoServerModule
implements ServerModule {
    private final WebServer server;
    private final Config config;
    private final Log log;

    public DatabaseRoleInfoServerModule(WebServer server, Config config, LogProvider logProvider) {
        this.server = server;
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
    }

    public void start() {
        URI baseUri = this.managementApiUri();
        this.server.addJAXRSClasses(this.getClassNames(), baseUri.toString(), null);
        this.log.info("Mounted REST API at: %s", new Object[]{baseUri.toString()});
    }

    public void stop() {
        URI baseUri = this.managementApiUri();
        this.server.removeJAXRSClasses(this.getClassNames(), baseUri.toString());
    }

    private List<String> getClassNames() {
        return Arrays.asList(MasterInfoService.class.getName(), CoreDatabaseAvailabilityService.class.getName(), ReadReplicaDatabaseAvailabilityService.class.getName(), CausalClusteringService.class.getName());
    }

    private URI managementApiUri() {
        return (URI)this.config.get(ServerSettings.management_api_path);
    }
}

