/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.causalclustering;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.server.rest.causalclustering.CausalClusteringDiscovery;
import org.neo4j.server.rest.causalclustering.CausalClusteringStatus;
import org.neo4j.server.rest.causalclustering.ClusterStatusResponse;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

abstract class BaseStatus
implements CausalClusteringStatus {
    private final OutputFormat output;

    BaseStatus(OutputFormat output) {
        this.output = output;
    }

    @Override
    public Response discover() {
        return this.output.ok((Representation)new CausalClusteringDiscovery("server/causalclustering/"));
    }

    Response statusResponse(long lastAppliedRaftIndex, boolean isParticipatingInRaftGroup, Collection<MemberId> votingMembers, boolean isHealthy, MemberId memberId, MemberId leader, Duration millisSinceLastLeaderMessage, boolean isCore) {
        String jsonObject;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jsonObject = objectMapper.writeValueAsString((Object)new ClusterStatusResponse(lastAppliedRaftIndex, isParticipatingInRaftGroup, votingMembers, isHealthy, memberId, leader, millisSinceLastLeaderMessage, isCore));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity((Object)jsonObject).build();
    }

    Response positiveResponse() {
        return this.plainTextResponse(Response.Status.OK, "true");
    }

    Response negativeResponse() {
        return this.plainTextResponse(Response.Status.NOT_FOUND, "false");
    }

    private Response plainTextResponse(Response.Status status, String entityBody) {
        return Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)entityBody).build();
    }
}

