/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Locale;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.output.EventReporter;
import org.neo4j.metrics.output.RotatableCsvReporter;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

public class CsvOutput
implements Lifecycle,
EventReporter {
    private final Config config;
    private final MetricRegistry registry;
    private final Log logger;
    private final KernelContext kernelContext;
    private final FileSystemAbstraction fileSystem;
    private final JobScheduler scheduler;
    private RotatableCsvReporter csvReporter;
    private File outputPath;

    CsvOutput(Config config, MetricRegistry registry, Log logger, KernelContext kernelContext, FileSystemAbstraction fileSystem, JobScheduler scheduler) {
        this.config = config;
        this.registry = registry;
        this.logger = logger;
        this.kernelContext = kernelContext;
        this.fileSystem = fileSystem;
        this.scheduler = scheduler;
    }

    public void init() throws IOException {
        File configuredPath = (File)this.config.get(MetricsSettings.csvPath);
        if (configuredPath == null) {
            throw new IllegalArgumentException(MetricsSettings.csvPath.name() + " configuration is required since " + MetricsSettings.csvEnabled.name() + " is enabled");
        }
        Long rotationThreshold = (Long)this.config.get(MetricsSettings.csvRotationThreshold);
        Integer maxArchives = (Integer)this.config.get(MetricsSettings.csvMaxArchives);
        this.outputPath = CsvOutput.absoluteFileOrRelativeTo(this.kernelContext.directory(), configuredPath);
        this.csvReporter = RotatableCsvReporter.forRegistry(this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).formatFor(Locale.US).outputStreamSupplierFactory(this.getFileRotatingFileOutputStreamSupplier(rotationThreshold, maxArchives)).build(this.ensureDirectoryExists(this.outputPath));
    }

    public void start() {
        this.csvReporter.start(((Duration)this.config.get(MetricsSettings.csvInterval)).toMillis(), TimeUnit.MILLISECONDS);
        this.logger.info("Sending metrics to CSV file at " + this.outputPath);
    }

    public void stop() {
        this.csvReporter.stop();
    }

    public void shutdown() {
        this.csvReporter = null;
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        this.csvReporter.report(gauges, counters, histograms, meters, timers);
    }

    private BiFunction<File, RotatingFileOutputStreamSupplier.RotationListener, RotatingFileOutputStreamSupplier> getFileRotatingFileOutputStreamSupplier(Long rotationThreshold, Integer maxArchives) {
        return (file, listener) -> {
            try {
                return new RotatingFileOutputStreamSupplier(this.fileSystem, file, rotationThreshold.longValue(), 0L, maxArchives.intValue(), this.scheduler.executor(Group.LOG_ROTATION), listener);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private File ensureDirectoryExists(File dir) throws IOException {
        if (!this.fileSystem.fileExists(dir)) {
            this.fileSystem.mkdirs(dir);
        }
        if (!this.fileSystem.isDirectory(dir)) {
            throw new IllegalStateException("The given path for CSV files points to a file, but a directory is required: " + dir.getAbsolutePath());
        }
        return dir;
    }

    private static File absoluteFileOrRelativeTo(File baseDirectoryIfRelative, File absoluteOrRelativeFile) {
        return absoluteOrRelativeFile.isAbsolute() ? absoluteOrRelativeFile : new File(baseDirectoryIfRelative, absoluteOrRelativeFile.getPath());
    }
}

