/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.metrics.output.EventReporter;
import org.neo4j.metrics.output.PrometheusHttpServer;

public class PrometheusOutput
implements Lifecycle,
EventReporter {
    protected PrometheusHttpServer server;
    private final HostnamePort hostnamePort;
    private final MetricRegistry registry;
    private final Log logger;
    private final ConnectorPortRegister portRegister;
    private final Map<String, Object> registeredEvents = new ConcurrentHashMap<String, Object>();
    private final MetricRegistry eventRegistry;

    PrometheusOutput(HostnamePort hostnamePort, MetricRegistry registry, Log logger, ConnectorPortRegister portRegister) {
        this.hostnamePort = hostnamePort;
        this.registry = registry;
        this.logger = logger;
        this.portRegister = portRegister;
        this.eventRegistry = new MetricRegistry();
    }

    public void init() {
        CollectorRegistry.defaultRegistry.register((Collector)new DropwizardExports(this.registry));
        CollectorRegistry.defaultRegistry.register((Collector)new DropwizardExports(this.eventRegistry));
    }

    public void start() throws Throwable {
        if (this.server == null) {
            this.server = new PrometheusHttpServer(this.hostnamePort.getHost(), this.hostnamePort.getPort());
            this.portRegister.register("prometheus", this.server.getAddress());
            this.logger.info("Started publishing Prometheus metrics at http://" + this.server.getAddress() + "/metrics");
        }
    }

    public void stop() {
        if (this.server != null) {
            String address = this.server.getAddress().toString();
            this.server.stop();
            this.server = null;
            this.logger.info("Stopped Prometheus endpoint at http://" + address + "/metrics");
        }
    }

    public void shutdown() {
        this.stop();
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (!gauges.isEmpty()) {
            String gaugeKey = gauges.firstKey();
            if (!this.registeredEvents.containsKey(gaugeKey)) {
                this.eventRegistry.register(gaugeKey, (Metric)((Gauge)() -> this.registeredEvents.get(gaugeKey)));
            }
            this.registeredEvents.put(gaugeKey, ((Gauge)gauges.get(gaugeKey)).getValue());
        }
        if (!meters.isEmpty()) {
            final String meterKey = meters.firstKey();
            if (!this.registeredEvents.containsKey(meterKey)) {
                this.eventRegistry.register(meterKey, (Metric)new Counter(){

                    public long getCount() {
                        return ((Number)PrometheusOutput.this.registeredEvents.get(meterKey)).longValue();
                    }
                });
            }
            this.registeredEvents.put(meterKey, ((Meter)meters.get(meterKey)).getCount());
        }
    }
}

