/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.causalclustering;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.function.Supplier;
import org.neo4j.causalclustering.core.consensus.CoreMetaData;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.metrics.metric.MetricsCounter;
import org.neo4j.metrics.source.causalclustering.InFlightCacheMetric;
import org.neo4j.metrics.source.causalclustering.RaftLogAppendIndexMetric;
import org.neo4j.metrics.source.causalclustering.RaftLogCommitIndexMetric;
import org.neo4j.metrics.source.causalclustering.RaftMessageProcessingMetric;
import org.neo4j.metrics.source.causalclustering.RaftTermMetric;
import org.neo4j.metrics.source.causalclustering.ReplicationMetric;
import org.neo4j.metrics.source.causalclustering.TxPullRequestsMetric;
import org.neo4j.metrics.source.causalclustering.TxRetryMetric;

@Documented(value=".Core metrics")
public class CoreMetrics
extends LifecycleAdapter {
    private static final String CAUSAL_CLUSTERING_PREFIX = "neo4j.causal_clustering.core";
    @Documented(value="Append index of the RAFT log")
    public static final String APPEND_INDEX = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"append_index"});
    @Documented(value="Commit index of the RAFT log")
    public static final String COMMIT_INDEX = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"commit_index"});
    @Documented(value="RAFT Term of this server")
    public static final String TERM = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"term"});
    @Documented(value="Transaction retries")
    public static final String TX_RETRIES = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"tx_retries"});
    @Documented(value="Is this server the leader?")
    public static final String IS_LEADER = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"is_leader"});
    @Documented(value="In-flight cache total bytes")
    public static final String TOTAL_BYTES = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "total_bytes"});
    @Documented(value="In-flight cache max bytes")
    public static final String MAX_BYTES = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "max_bytes"});
    @Documented(value="In-flight cache element count")
    public static final String ELEMENT_COUNT = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "element_count"});
    @Documented(value="In-flight cache maximum elements")
    public static final String MAX_ELEMENTS = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "max_elements"});
    @Documented(value="In-flight cache hits")
    public static final String HITS = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "hits"});
    @Documented(value="In-flight cache misses")
    public static final String MISSES = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"in_flight_cache", "misses"});
    @Documented(value="Delay between RAFT message receive and process")
    public static final String DELAY = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"message_processing_delay"});
    @Documented(value="Timer for RAFT message processing")
    public static final String TIMER = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"message_processing_timer"});
    @Documented(value="Raft replication new request count")
    public static final String REPLICATION_NEW = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"replication_new"});
    @Documented(value="Raft replication attempt count")
    public static final String REPLICATION_ATTEMPT = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"replication_attempt"});
    @Documented(value="Raft Replication success count")
    public static final String REPLICATION_SUCCESS = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"replication_success"});
    @Documented(value="Raft Replication fail count")
    public static final String REPLICATION_FAIL = MetricRegistry.name((String)"neo4j.causal_clustering.core", (String[])new String[]{"replication_fail"});
    private Monitors monitors;
    private MetricRegistry registry;
    private Supplier<CoreMetaData> coreMetaData;
    private final RaftLogCommitIndexMetric raftLogCommitIndexMetric = new RaftLogCommitIndexMetric();
    private final RaftLogAppendIndexMetric raftLogAppendIndexMetric = new RaftLogAppendIndexMetric();
    private final RaftTermMetric raftTermMetric = new RaftTermMetric();
    private final TxPullRequestsMetric txPullRequestsMetric = new TxPullRequestsMetric();
    private final TxRetryMetric txRetryMetric = new TxRetryMetric();
    private final InFlightCacheMetric inFlightCacheMetric = new InFlightCacheMetric();
    private final RaftMessageProcessingMetric raftMessageProcessingMetric = RaftMessageProcessingMetric.create();
    private final ReplicationMetric replicationMetric = new ReplicationMetric();

    public CoreMetrics(Monitors monitors, MetricRegistry registry, Supplier<CoreMetaData> coreMetaData) {
        this.monitors = monitors;
        this.registry = registry;
        this.coreMetaData = coreMetaData;
    }

    public void start() {
        this.monitors.addMonitorListener((Object)this.raftLogCommitIndexMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.raftLogAppendIndexMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.raftTermMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.txPullRequestsMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.txRetryMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.inFlightCacheMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.raftMessageProcessingMetric, new String[0]);
        this.monitors.addMonitorListener((Object)this.replicationMetric, new String[0]);
        this.registry.register(COMMIT_INDEX, (Metric)((Gauge)this.raftLogCommitIndexMetric::commitIndex));
        this.registry.register(APPEND_INDEX, (Metric)((Gauge)this.raftLogAppendIndexMetric::appendIndex));
        this.registry.register(TERM, (Metric)((Gauge)this.raftTermMetric::term));
        this.registry.register(TX_RETRIES, (Metric)new MetricsCounter(this.txRetryMetric::transactionsRetries));
        this.registry.register(IS_LEADER, (Metric)new LeaderGauge());
        this.registry.register(TOTAL_BYTES, (Metric)((Gauge)this.inFlightCacheMetric::getTotalBytes));
        this.registry.register(HITS, (Metric)new MetricsCounter(this.inFlightCacheMetric::getHits));
        this.registry.register(MISSES, (Metric)new MetricsCounter(this.inFlightCacheMetric::getMisses));
        this.registry.register(MAX_BYTES, (Metric)((Gauge)this.inFlightCacheMetric::getMaxBytes));
        this.registry.register(MAX_ELEMENTS, (Metric)((Gauge)this.inFlightCacheMetric::getMaxElements));
        this.registry.register(ELEMENT_COUNT, (Metric)((Gauge)this.inFlightCacheMetric::getElementCount));
        this.registry.register(DELAY, (Metric)((Gauge)this.raftMessageProcessingMetric::delay));
        this.registry.register(TIMER, (Metric)this.raftMessageProcessingMetric.timer());
        this.registry.register(REPLICATION_NEW, (Metric)new MetricsCounter(this.replicationMetric::newReplicationCount));
        this.registry.register(REPLICATION_ATTEMPT, (Metric)new MetricsCounter(this.replicationMetric::attemptCount));
        this.registry.register(REPLICATION_SUCCESS, (Metric)new MetricsCounter(this.replicationMetric::successCount));
        this.registry.register(REPLICATION_FAIL, (Metric)new MetricsCounter(this.replicationMetric::failCount));
        for (RaftMessages.Type type : RaftMessages.Type.values()) {
            this.registry.register(this.messageTimerName(type), (Metric)this.raftMessageProcessingMetric.timer(type));
        }
    }

    public void stop() {
        this.registry.remove(COMMIT_INDEX);
        this.registry.remove(APPEND_INDEX);
        this.registry.remove(TERM);
        this.registry.remove(TX_RETRIES);
        this.registry.remove(IS_LEADER);
        this.registry.remove(TOTAL_BYTES);
        this.registry.remove(HITS);
        this.registry.remove(MISSES);
        this.registry.remove(MAX_BYTES);
        this.registry.remove(MAX_ELEMENTS);
        this.registry.remove(ELEMENT_COUNT);
        this.registry.remove(DELAY);
        this.registry.remove(TIMER);
        this.registry.remove(REPLICATION_NEW);
        this.registry.remove(REPLICATION_ATTEMPT);
        this.registry.remove(REPLICATION_SUCCESS);
        this.registry.remove(REPLICATION_FAIL);
        for (RaftMessages.Type type : RaftMessages.Type.values()) {
            this.registry.remove(this.messageTimerName(type));
        }
        this.monitors.removeMonitorListener((Object)this.raftLogCommitIndexMetric);
        this.monitors.removeMonitorListener((Object)this.raftLogAppendIndexMetric);
        this.monitors.removeMonitorListener((Object)this.raftTermMetric);
        this.monitors.removeMonitorListener((Object)this.txPullRequestsMetric);
        this.monitors.removeMonitorListener((Object)this.txRetryMetric);
        this.monitors.removeMonitorListener((Object)this.inFlightCacheMetric);
        this.monitors.removeMonitorListener((Object)this.raftMessageProcessingMetric);
        this.monitors.removeMonitorListener((Object)this.replicationMetric);
    }

    private String messageTimerName(RaftMessages.Type type) {
        return MetricRegistry.name((String)TIMER, (String[])new String[]{type.name().toLowerCase()});
    }

    private class LeaderGauge
    implements Gauge<Integer> {
        private LeaderGauge() {
        }

        public Integer getValue() {
            return ((CoreMetaData)CoreMetrics.this.coreMetaData.get()).isLeader() ? 1 : 0;
        }
    }
}

