/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.causalclustering;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.metrics.metric.MetricsCounter;
import org.neo4j.metrics.source.causalclustering.PullRequestMetric;

@Documented(value=".Read Replica Metrics")
public class ReadReplicaMetrics
extends LifecycleAdapter {
    private static final String CAUSAL_CLUSTERING_PREFIX = "neo4j.causal_clustering.read_replica";
    @Documented(value="The total number of pull requests made by this instance")
    public static final String PULL_UPDATES = MetricRegistry.name((String)"neo4j.causal_clustering.read_replica", (String[])new String[]{"pull_updates"});
    @Documented(value="The highest transaction id requested in a pull update by this instance")
    public static final String PULL_UPDATE_HIGHEST_TX_ID_REQUESTED = MetricRegistry.name((String)"neo4j.causal_clustering.read_replica", (String[])new String[]{"pull_update_highest_tx_id_requested"});
    @Documented(value="The highest transaction id that has been pulled in the last pull updates by this instance")
    public static final String PULL_UPDATE_HIGHEST_TX_ID_RECEIVED = MetricRegistry.name((String)"neo4j.causal_clustering.read_replica", (String[])new String[]{"pull_update_highest_tx_id_received"});
    private Monitors monitors;
    private MetricRegistry registry;
    private final PullRequestMetric pullRequestMetric = new PullRequestMetric();

    public ReadReplicaMetrics(Monitors monitors, MetricRegistry registry) {
        this.monitors = monitors;
        this.registry = registry;
    }

    public void start() {
        this.monitors.addMonitorListener((Object)this.pullRequestMetric, new String[0]);
        this.registry.register(PULL_UPDATES, (Metric)new MetricsCounter(this.pullRequestMetric::numberOfRequests));
        this.registry.register(PULL_UPDATE_HIGHEST_TX_ID_REQUESTED, (Metric)new MetricsCounter(this.pullRequestMetric::lastRequestedTxId));
        this.registry.register(PULL_UPDATE_HIGHEST_TX_ID_RECEIVED, (Metric)new MetricsCounter(this.pullRequestMetric::lastReceivedTxId));
    }

    public void stop() {
        this.registry.remove(PULL_UPDATES);
        this.registry.remove(PULL_UPDATE_HIGHEST_TX_ID_REQUESTED);
        this.registry.remove(PULL_UPDATE_HIGHEST_TX_ID_RECEIVED);
        this.monitors.removeMonitorListener((Object)this.pullRequestMetric);
    }
}

