/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.cluster;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.kernel.ha.SlaveUpdatePuller;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.metrics.metric.MetricsCounter;

@Documented(value=".Cluster metrics")
public class ClusterMetrics
extends LifecycleAdapter {
    private static final String NAME_PREFIX = "neo4j.cluster";
    @Documented(value="The total number of update pulls executed by this instance")
    public static final String SLAVE_PULL_UPDATES = MetricRegistry.name((String)"neo4j.cluster", (String[])new String[]{"slave_pull_updates"});
    @Documented(value="The highest transaction id that has been pulled in the last pull updates by this instance")
    public static final String SLAVE_PULL_UPDATE_UP_TO_TX = MetricRegistry.name((String)"neo4j.cluster", (String[])new String[]{"slave_pull_update_up_to_tx"});
    @Documented(value="Whether or not this instance is the master in the cluster")
    public static final String IS_MASTER = MetricRegistry.name((String)"neo4j.cluster", (String[])new String[]{"is_master"});
    @Documented(value="Whether or not this instance is available in the cluster")
    public static final String IS_AVAILABLE = MetricRegistry.name((String)"neo4j.cluster", (String[])new String[]{"is_available"});
    private final Monitors monitors;
    private final MetricRegistry registry;
    private final SlaveUpdatePullerMonitor monitor = new SlaveUpdatePullerMonitor();
    private final Supplier<ClusterMembers> clusterMembers;

    public ClusterMetrics(Monitors monitors, MetricRegistry registry, Supplier<ClusterMembers> clusterMembers) {
        this.monitors = monitors;
        this.registry = registry;
        this.clusterMembers = clusterMembers;
    }

    public void start() {
        this.monitors.addMonitorListener((Object)this.monitor, new String[0]);
        this.registry.register(IS_MASTER, (Metric)new RoleGauge("master"::equals));
        this.registry.register(IS_AVAILABLE, (Metric)new RoleGauge(s -> !"UNKNOWN".equals(s)));
        this.registry.register(SLAVE_PULL_UPDATES, (Metric)new MetricsCounter(() -> this.monitor.events.get()));
        this.registry.register(SLAVE_PULL_UPDATE_UP_TO_TX, (Metric)new MetricsCounter(() -> this.monitor.lastAppliedTxId));
    }

    public void stop() {
        this.registry.remove(SLAVE_PULL_UPDATES);
        this.registry.remove(SLAVE_PULL_UPDATE_UP_TO_TX);
        this.registry.remove(IS_MASTER);
        this.registry.remove(IS_AVAILABLE);
        this.monitors.removeMonitorListener((Object)this.monitor);
    }

    private class RoleGauge
    implements Gauge<Integer> {
        private Predicate<String> rolePredicate;

        RoleGauge(Predicate<String> rolePredicate) {
            this.rolePredicate = rolePredicate;
        }

        public Integer getValue() {
            ClusterMembers clusterMembers = (ClusterMembers)ClusterMetrics.this.clusterMembers.get();
            return clusterMembers != null && this.rolePredicate.test(clusterMembers.getCurrentMemberRole()) ? 1 : 0;
        }
    }

    private static class SlaveUpdatePullerMonitor
    implements SlaveUpdatePuller.Monitor {
        private AtomicLong events = new AtomicLong();
        private volatile long lastAppliedTxId;

        private SlaveUpdatePullerMonitor() {
        }

        public void pulledUpdates(long lastAppliedTxId) {
            this.events.incrementAndGet();
            this.lastAppliedTxId = lastAppliedTxId;
        }
    }
}

