/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.db;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Collections;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerMonitor;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DefaultCheckPointerTracer;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.metrics.metric.MetricsCounter;
import org.neo4j.metrics.output.EventReporter;

@Documented(value=".Database checkpointing metrics")
public class CheckPointingMetrics
extends LifecycleAdapter {
    private static final String CHECK_POINT_PREFIX = "neo4j.check_point";
    @Documented(value="The total number of check point events executed so far")
    public static final String CHECK_POINT_EVENTS = MetricRegistry.name((String)"neo4j.check_point", (String[])new String[]{"events"});
    @Documented(value="The total time spent in check pointing so far")
    public static final String CHECK_POINT_TOTAL_TIME = MetricRegistry.name((String)"neo4j.check_point", (String[])new String[]{"total_time"});
    @Documented(value="The duration of the check point event")
    @Deprecated
    public static final String CHECK_POINT_DURATION = MetricRegistry.name((String)"neo4j.check_point", (String[])new String[]{"check_point_duration"});
    private final MetricRegistry registry;
    private final Monitors monitors;
    private final Supplier<CheckPointerMonitor> checkPointerMonitorSupplier;
    private final DefaultCheckPointerTracer.Monitor listener;

    public CheckPointingMetrics(EventReporter reporter, MetricRegistry registry, Monitors monitors, Supplier<CheckPointerMonitor> checkPointerMonitorSupplier) {
        this.registry = registry;
        this.monitors = monitors;
        this.checkPointerMonitorSupplier = checkPointerMonitorSupplier;
        this.listener = durationMillis -> {
            TreeMap<String, Gauge> gauges = new TreeMap<String, Gauge>();
            gauges.put(CHECK_POINT_DURATION, () -> durationMillis);
            reporter.report(gauges, Collections.emptySortedMap(), Collections.emptySortedMap(), Collections.emptySortedMap(), Collections.emptySortedMap());
        };
    }

    public void start() {
        this.monitors.addMonitorListener((Object)this.listener, new String[0]);
        CheckPointerMonitor checkPointerMonitor = this.checkPointerMonitorSupplier.get();
        this.registry.register(CHECK_POINT_EVENTS, (Metric)new MetricsCounter(() -> ((CheckPointerMonitor)checkPointerMonitor).numberOfCheckPointEvents()));
        this.registry.register(CHECK_POINT_TOTAL_TIME, (Metric)new MetricsCounter(() -> ((CheckPointerMonitor)checkPointerMonitor).checkPointAccumulatedTotalTimeMillis()));
    }

    public void stop() {
        this.monitors.removeMonitorListener((Object)this.listener);
        this.registry.remove(CHECK_POINT_EVENTS);
        this.registry.remove(CHECK_POINT_TOTAL_TIME);
    }
}

