/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.db;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import org.neo4j.io.pagecache.monitoring.PageCacheCounters;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.metrics.metric.MetricsCounter;

@Documented(value=".Database page cache metrics")
public class PageCacheMetrics
extends LifecycleAdapter {
    private static final String PAGE_CACHE_PREFIX = "neo4j.page_cache";
    @Documented(value="The total number of exceptions seen during the eviction process in the page cache")
    public static final String PC_EVICTION_EXCEPTIONS = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"eviction_exceptions"});
    @Documented(value="The total number of flushes executed by the page cache")
    public static final String PC_FLUSHES = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"flushes"});
    @Documented(value="The total number of page unpins executed by the page cache")
    public static final String PC_UNPINS = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"unpins"});
    @Documented(value="The total number of page pins executed by the page cache")
    public static final String PC_PINS = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"pins"});
    @Documented(value="The total number of page evictions executed by the page cache")
    public static final String PC_EVICTIONS = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"evictions"});
    @Documented(value="The total number of page faults happened in the page cache")
    public static final String PC_PAGE_FAULTS = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"page_faults"});
    @Documented(value="The total number of page hits happened in the page cache")
    public static final String PC_HITS = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"hits"});
    @Documented(value="The ratio of hits to the total number of lookups in the page cache")
    public static final String PC_HIT_RATIO = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"hit_ratio"});
    @Documented(value="The ratio of number of used pages to total number of available pages")
    public static final String PC_USAGE_RATIO = MetricRegistry.name((String)"neo4j.page_cache", (String[])new String[]{"usage_ratio"});
    private final MetricRegistry registry;
    private final PageCacheCounters pageCacheCounters;

    public PageCacheMetrics(MetricRegistry registry, PageCacheCounters pageCacheCounters) {
        this.registry = registry;
        this.pageCacheCounters = pageCacheCounters;
    }

    public void start() {
        this.registry.register(PC_PAGE_FAULTS, (Metric)new MetricsCounter(() -> ((PageCacheCounters)this.pageCacheCounters).faults()));
        this.registry.register(PC_EVICTIONS, (Metric)new MetricsCounter(() -> ((PageCacheCounters)this.pageCacheCounters).evictions()));
        this.registry.register(PC_PINS, (Metric)new MetricsCounter(() -> ((PageCacheCounters)this.pageCacheCounters).pins()));
        this.registry.register(PC_UNPINS, (Metric)new MetricsCounter(() -> ((PageCacheCounters)this.pageCacheCounters).unpins()));
        this.registry.register(PC_HITS, (Metric)new MetricsCounter(() -> ((PageCacheCounters)this.pageCacheCounters).hits()));
        this.registry.register(PC_FLUSHES, (Metric)new MetricsCounter(() -> ((PageCacheCounters)this.pageCacheCounters).flushes()));
        this.registry.register(PC_EVICTION_EXCEPTIONS, (Metric)new MetricsCounter(() -> ((PageCacheCounters)this.pageCacheCounters).evictionExceptions()));
        this.registry.register(PC_HIT_RATIO, (Metric)((Gauge)() -> ((PageCacheCounters)this.pageCacheCounters).hitRatio()));
        this.registry.register(PC_USAGE_RATIO, (Metric)((Gauge)() -> ((PageCacheCounters)this.pageCacheCounters).usageRatio()));
    }

    public void stop() {
        this.registry.remove(PC_PAGE_FAULTS);
        this.registry.remove(PC_EVICTIONS);
        this.registry.remove(PC_PINS);
        this.registry.remove(PC_UNPINS);
        this.registry.remove(PC_HITS);
        this.registry.remove(PC_FLUSHES);
        this.registry.remove(PC_EVICTION_EXCEPTIONS);
        this.registry.remove(PC_HIT_RATIO);
        this.registry.remove(PC_USAGE_RATIO);
    }
}

