/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.source.jvm;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import org.neo4j.metrics.metric.MetricsCounter;
import org.neo4j.metrics.source.jvm.JvmMetrics;

public class GCMetrics
extends JvmMetrics {
    public static final String GC_PREFIX = MetricRegistry.name((String)"vm", (String[])new String[]{"gc"});
    public static final String GC_TIME = MetricRegistry.name((String)GC_PREFIX, (String[])new String[]{"time"});
    public static final String GC_COUNT = MetricRegistry.name((String)GC_PREFIX, (String[])new String[]{"count"});
    private final MetricRegistry registry;

    public GCMetrics(MetricRegistry registry) {
        this.registry = registry;
    }

    public void start() {
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            this.registry.register(MetricRegistry.name((String)GC_TIME, (String[])new String[]{GCMetrics.prettifyName(gcBean.getName())}), (Metric)new MetricsCounter(gcBean::getCollectionTime));
            this.registry.register(MetricRegistry.name((String)GC_COUNT, (String[])new String[]{GCMetrics.prettifyName(gcBean.getName())}), (Metric)new MetricsCounter(gcBean::getCollectionCount));
        }
    }

    public void stop() {
        this.registry.removeMatching((name, metric) -> name.startsWith(GC_PREFIX));
    }
}

