/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.security;

import com.neo4j.security.SystemGraphExecutor;
import com.neo4j.security.SystemGraphImportOptions;
import com.neo4j.security.SystemGraphRealm;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.SecurityModule;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.EnterpriseSecurityModule;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.FileRoleRepository;
import org.neo4j.server.security.enterprise.auth.RoleRepository;
import org.neo4j.server.security.enterprise.auth.SecureHasher;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;
import org.neo4j.server.security.enterprise.log.SecurityLog;

public class CommercialSecurityModule
extends EnterpriseSecurityModule {
    public static final String IMPORT_AUTH_COMMAND_NAME = "import-auth";
    public static final String USER_IMPORT_FILENAME = ".users.import";
    public static final String ROLE_IMPORT_FILENAME = ".roles.import";
    private static DatabaseManager databaseManager;

    public CommercialSecurityModule() {
        super("commercial-security-module");
    }

    public void setup(SecurityModule.Dependencies dependencies) throws KernelException, IOException {
        databaseManager = (DatabaseManager)((Dependencies)dependencies.dependencySatisfier()).resolveDependency(DatabaseManager.class);
        super.setup(dependencies);
    }

    protected EnterpriseUserManager createInternalRealm(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem, JobScheduler jobScheduler, SecurityLog securityLog, AccessCapability accessCapability) {
        Object internalRealm = null;
        if (this.securityConfig.hasNativeProvider) {
            internalRealm = CommercialSecurityModule.createInternalFlatFileRealm((Config)config, (LogProvider)logProvider, (FileSystemAbstraction)fileSystem, (JobScheduler)jobScheduler);
        } else if (((CommercialSecurityConfig)this.securityConfig).hasSystemGraphProvider) {
            internalRealm = this.createSystemGraphRealm(config, logProvider, fileSystem, securityLog, accessCapability);
        }
        return internalRealm;
    }

    private SystemGraphRealm createSystemGraphRealm(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem, SecurityLog securityLog, AccessCapability accessCapability) {
        return new SystemGraphRealm(new SystemGraphExecutor(databaseManager, (String)config.get(GraphDatabaseSettings.active_database)), new SecureHasher(), (PasswordPolicy)new BasicPasswordPolicy(), CommercialSecurityModule.createAuthenticationStrategy((Config)config), (Boolean)config.get(SecuritySettings.native_authentication_enabled), (Boolean)config.get(SecuritySettings.native_authorization_enabled), securityLog, CommercialSecurityModule.configureImportOptions(config, logProvider, fileSystem, accessCapability));
    }

    private static SystemGraphImportOptions configureImportOptions(Config config, LogProvider logProvider, FileSystemAbstraction fileSystem, AccessCapability accessCapability) {
        File parentFile = CommunitySecurityModule.getUserRepositoryFile((Config)config).getParentFile();
        File userImportFile = new File(parentFile, USER_IMPORT_FILENAME);
        File roleImportFile = new File(parentFile, ROLE_IMPORT_FILENAME);
        boolean shouldPerformImport = fileSystem.fileExists(userImportFile) || fileSystem.fileExists(roleImportFile);
        boolean mayPerformMigration = !shouldPerformImport && CommercialSecurityModule.mayPerformMigration(config, accessCapability);
        boolean shouldPurgeImportRepositoriesAfterSuccesfulImport = shouldPerformImport;
        boolean shouldResetSystemGraphAuthBeforeImport = false;
        Supplier<UserRepository> importUserRepositorySupplier = () -> new FileUserRepository(fileSystem, userImportFile, logProvider);
        Supplier<RoleRepository> importRoleRepositorySupplier = () -> new FileRoleRepository(fileSystem, roleImportFile, logProvider);
        Supplier<UserRepository> migrationUserRepositorySupplier = () -> CommunitySecurityModule.getUserRepository((Config)config, (LogProvider)logProvider, (FileSystemAbstraction)fileSystem);
        Supplier<RoleRepository> migrationRoleRepositorySupplier = () -> EnterpriseSecurityModule.getRoleRepository((Config)config, (LogProvider)logProvider, (FileSystemAbstraction)fileSystem);
        Supplier<UserRepository> initialUserRepositorySupplier = () -> CommunitySecurityModule.getInitialUserRepository((Config)config, (LogProvider)logProvider, (FileSystemAbstraction)fileSystem);
        Supplier<UserRepository> defaultAdminRepositorySupplier = () -> CommercialSecurityModule.getDefaultAdminRepository((Config)config, (LogProvider)logProvider, (FileSystemAbstraction)fileSystem);
        return new SystemGraphImportOptions(shouldPerformImport, mayPerformMigration, shouldPurgeImportRepositoriesAfterSuccesfulImport, shouldResetSystemGraphAuthBeforeImport, importUserRepositorySupplier, importRoleRepositorySupplier, migrationUserRepositorySupplier, migrationRoleRepositorySupplier, initialUserRepositorySupplier, defaultAdminRepositorySupplier);
    }

    private static SystemGraphImportOptions configureImportOptionsForOfflineImport(Config config, LogProvider logProvider, UserRepository importUserRepository, RoleRepository importRoleRepository, boolean shouldResetSystemGraphAuthBeforeImport) {
        boolean shouldPerformImport = true;
        boolean mayPerformMigration = false;
        boolean shouldPurgeImportRepositoriesAfterSuccesfulImport = false;
        Supplier<UserRepository> importUserRepositorySupplier = () -> importUserRepository;
        Supplier<RoleRepository> importRoleRepositorySupplier = () -> importRoleRepository;
        return new SystemGraphImportOptions(shouldPerformImport, mayPerformMigration, shouldPurgeImportRepositoriesAfterSuccesfulImport, shouldResetSystemGraphAuthBeforeImport, importUserRepositorySupplier, importRoleRepositorySupplier, null, null, null, null);
    }

    private static boolean mayPerformMigration(Config config, AccessCapability accessCapability) {
        boolean mayPerformMigration = false;
        try {
            accessCapability.assertCanWrite();
            mayPerformMigration = true;
        }
        catch (WriteOperationsNotAllowedException writeOperationsNotAllowedException) {
            // empty catch block
        }
        return mayPerformMigration;
    }

    protected EnterpriseSecurityModule.SecurityConfig getValidatedSecurityConfig(Config config) {
        CommercialSecurityConfig securityConfig = new CommercialSecurityConfig(config);
        securityConfig.validate();
        return securityConfig;
    }

    public static SystemGraphRealm createSystemGraphRealmForOfflineImport(Config config, LogProvider logProvider, SecurityLog securityLog, DatabaseManager databaseManager, UserRepository importUserRepository, RoleRepository importRoleRepository, boolean shouldResetSystemGraphAuthBeforeImport) {
        return new SystemGraphRealm(new SystemGraphExecutor(databaseManager, "system.db"), new SecureHasher(), (PasswordPolicy)new BasicPasswordPolicy(), CommercialSecurityModule.createAuthenticationStrategy((Config)config), false, true, securityLog, CommercialSecurityModule.configureImportOptionsForOfflineImport(config, logProvider, importUserRepository, importRoleRepository, shouldResetSystemGraphAuthBeforeImport));
    }

    static class CommercialSecurityConfig
    extends EnterpriseSecurityModule.SecurityConfig {
        final boolean hasSystemGraphProvider;

        CommercialSecurityConfig(Config config) {
            super(config);
            this.hasSystemGraphProvider = this.authProviders.contains("system-graph");
        }

        protected void validate() {
            if (this.hasSystemGraphProvider && !this.nativeAuthentication && !this.nativeAuthorization) {
                throw CommercialSecurityModule.illegalConfiguration((String)"System graph auth provider configured, but both authentication and authorization are disabled.");
            }
            if (this.hasNativeProvider && this.hasSystemGraphProvider) {
                throw CommercialSecurityModule.illegalConfiguration((String)"Both system graph auth provider and native auth provider configured, but they cannot be used together. Please remove one of them from the configuration.");
            }
            super.validate();
        }
    }
}

