/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.security;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.cypher.internal.javacompat.QueryResultProvider;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.AuthProviderFailedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SystemGraphExecutor {
    private final DatabaseManager databaseManager;
    private final String activeDbName;
    private GraphDatabaseFacade systemDb;
    private ThreadToStatementContextBridge threadToStatementContextBridge;

    SystemGraphExecutor(DatabaseManager databaseManager, String activeDbName) {
        this.databaseManager = databaseManager;
        this.activeDbName = activeDbName;
    }

    long executeQueryLong(String query) {
        MutableLong count = new MutableLong();
        QueryResult.QueryResultVisitor resultVisitor = row -> {
            count.setValue(((NumberValue)row.fields()[0]).longValue());
            return false;
        };
        this.executeQuery(query, Collections.emptyMap(), resultVisitor);
        return count.getValue();
    }

    void executeQueryWithConstraint(String query, Map<String, Object> params, String failureMessage) throws InvalidArgumentsException {
        QueryResult.QueryResultVisitor resultVisitor = row -> true;
        try {
            this.executeQuery(query, params, resultVisitor);
        }
        catch (Exception e) {
            if (e instanceof QueryExecutionException && ((QueryExecutionException)e).getStatusCode().contains("ConstraintValidationFailed")) {
                throw new InvalidArgumentsException(failureMessage);
            }
            throw e;
        }
    }

    boolean executeQueryWithParamCheck(String query, Map<String, Object> params) {
        MutableBoolean paramCheck = new MutableBoolean(false);
        QueryResult.QueryResultVisitor resultVisitor = row -> {
            paramCheck.setTrue();
            return true;
        };
        this.executeQuery(query, params, resultVisitor);
        return paramCheck.getValue();
    }

    boolean executeQueryWithParamCheck(String query, Map<String, Object> params, String errorMsg) throws InvalidArgumentsException {
        boolean paramCheck = this.executeQueryWithParamCheck(query, params);
        if (!paramCheck) {
            throw new InvalidArgumentsException(errorMsg);
        }
        return true;
    }

    Set<String> executeQueryWithResultSet(String query) {
        TreeSet<String> resultSet = new TreeSet<String>();
        QueryResult.QueryResultVisitor resultVisitor = row -> {
            resultSet.add(((TextValue)row.fields()[0]).stringValue());
            return true;
        };
        this.executeQuery(query, Collections.emptyMap(), resultVisitor);
        return resultSet;
    }

    Set<String> executeQueryWithResultSetAndParamCheck(String query, Map<String, Object> params, String errorMsg) throws InvalidArgumentsException {
        MutableBoolean success = new MutableBoolean(false);
        TreeSet<String> resultSet = new TreeSet<String>();
        QueryResult.QueryResultVisitor resultVisitor = row -> {
            success.setTrue();
            Value value = (Value)row.fields()[0];
            if (value != Values.NO_VALUE) {
                resultSet.add(((TextValue)value).stringValue());
            }
            return true;
        };
        this.executeQuery(query, params, resultVisitor);
        if (success.isFalse()) {
            throw new InvalidArgumentsException(errorMsg);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeQuery(String query, Map<String, Object> params, QueryResult.QueryResultVisitor resultVisitor) {
        ThreadToStatementContextBridge statementContext = this.getThreadToStatementContextBridge();
        if (statementContext.hasTransaction()) {
            KernelTransaction outerTx = statementContext.getKernelTransactionBoundToThisThread(true);
            statementContext.unbindTransactionFromCurrentThread();
            try {
                this.systemDbExecute(query, params, resultVisitor);
            }
            finally {
                statementContext.unbindTransactionFromCurrentThread();
                statementContext.bindTransactionToCurrentThread(outerTx);
            }
        } else {
            this.systemDbExecute(query, params, resultVisitor);
        }
    }

    private void systemDbExecute(String query, Map<String, Object> parameters, QueryResult.QueryResultVisitor resultVisitor) {
        try (Transaction transaction = this.getSystemDb().beginTx();){
            this.systemDbExecuteWithinTransaction(query, parameters, resultVisitor);
            transaction.success();
        }
    }

    private void systemDbExecuteWithinTransaction(String query, Map<String, Object> parameters, QueryResult.QueryResultVisitor resultVisitor) {
        Result result = this.getSystemDb().execute(query, parameters);
        QueryResult queryResult = ((QueryResultProvider)result).queryResult();
        queryResult.accept(resultVisitor);
    }

    Transaction systemDbBeginTransaction() {
        Runnable onClose;
        final ThreadToStatementContextBridge statementContext = this.getThreadToStatementContextBridge();
        if (statementContext.hasTransaction()) {
            KernelTransaction outerTx = statementContext.getKernelTransactionBoundToThisThread(true);
            statementContext.unbindTransactionFromCurrentThread();
            onClose = () -> statementContext.bindTransactionToCurrentThread(outerTx);
        } else {
            onClose = () -> {};
        }
        final Transaction transaction = this.getSystemDb().beginTx();
        return new Transaction(){

            public void terminate() {
                transaction.terminate();
            }

            public void failure() {
                transaction.failure();
            }

            public void success() {
                transaction.success();
            }

            public void close() {
                try {
                    transaction.close();
                }
                finally {
                    statementContext.unbindTransactionFromCurrentThread();
                    onClose.run();
                }
            }

            public Lock acquireWriteLock(PropertyContainer entity) {
                return transaction.acquireWriteLock(entity);
            }

            public Lock acquireReadLock(PropertyContainer entity) {
                return transaction.acquireReadLock(entity);
            }
        };
    }

    protected ThreadToStatementContextBridge getThreadToStatementContextBridge() {
        if (this.threadToStatementContextBridge == null) {
            GraphDatabaseFacade activeDb = this.getDb(this.activeDbName);
            this.threadToStatementContextBridge = (ThreadToStatementContextBridge)activeDb.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        }
        return this.threadToStatementContextBridge;
    }

    private GraphDatabaseFacade getSystemDb() {
        if (this.systemDb == null) {
            this.systemDb = this.getDb("system.db");
        }
        return this.systemDb;
    }

    private GraphDatabaseFacade getDb(String dbName) {
        return (GraphDatabaseFacade)this.databaseManager.getDatabaseFacade(dbName).orElseThrow(() -> new AuthProviderFailedException("No database called `" + dbName + "` was found."));
    }
}

