/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.security;

import com.neo4j.security.SystemGraphCredential;
import com.neo4j.security.SystemGraphExecutor;
import com.neo4j.security.SystemGraphImportOptions;
import com.neo4j.security.SystemGraphShiroAuthenticationInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.pam.UnsupportedTokenException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.PredefinedRolesBuilder;
import org.neo4j.server.security.enterprise.auth.RealmLifecycle;
import org.neo4j.server.security.enterprise.auth.RoleRecord;
import org.neo4j.server.security.enterprise.auth.RoleRepository;
import org.neo4j.server.security.enterprise.auth.SecureHasher;
import org.neo4j.server.security.enterprise.auth.ShiroAuthToken;
import org.neo4j.server.security.enterprise.auth.ShiroAuthorizationInfoProvider;
import org.neo4j.server.security.enterprise.log.SecurityLog;
import org.neo4j.string.UTF8;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SystemGraphRealm
extends AuthorizingRealm
implements RealmLifecycle,
EnterpriseUserManager,
ShiroAuthorizationInfoProvider,
CredentialsMatcher {
    private final SystemGraphImportOptions importOptions;
    private final PasswordPolicy passwordPolicy;
    private final AuthenticationStrategy authenticationStrategy;
    private final boolean authenticationEnabled;
    private final boolean authorizationEnabled;
    private final SecureHasher secureHasher;
    private final SystemGraphExecutor systemGraphExecutor;
    private final SecurityLog securityLog;
    private static final String IS_SUSPENDED = "is_suspended";
    private static final Pattern usernamePattern = Pattern.compile("^[\\x21-\\x2B\\x2D-\\x39\\x3B-\\x7E]+$");
    private static final Pattern roleNamePattern = Pattern.compile("^[a-zA-Z0-9_]+$");

    SystemGraphRealm(SystemGraphExecutor systemGraphExecutor, SecureHasher secureHasher, PasswordPolicy passwordPolicy, AuthenticationStrategy authenticationStrategy, boolean authenticationEnabled, boolean authorizationEnabled, SecurityLog securityLog, SystemGraphImportOptions importOptions) {
        this.setName("system-graph");
        this.secureHasher = secureHasher;
        this.passwordPolicy = passwordPolicy;
        this.authenticationStrategy = authenticationStrategy;
        this.authenticationEnabled = authenticationEnabled;
        this.authorizationEnabled = authorizationEnabled;
        this.securityLog = securityLog;
        this.importOptions = importOptions;
        this.systemGraphExecutor = systemGraphExecutor;
        this.setAuthenticationCachingEnabled(true);
        this.setAuthorizationCachingEnabled(true);
        this.setCredentialsMatcher(this);
        this.setRolePermissionResolver(PredefinedRolesBuilder.rolePermissionResolver);
    }

    public void initialize() throws Throwable {
    }

    public void start() throws Throwable {
        if (this.authenticationEnabled || this.authorizationEnabled) {
            this.initializeSystemGraph();
        }
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
    }

    public boolean supports(AuthenticationToken token) {
        try {
            if (token instanceof ShiroAuthToken) {
                ShiroAuthToken shiroAuthToken = (ShiroAuthToken)token;
                return shiroAuthToken.getScheme().equals("basic") && shiroAuthToken.supportsRealm("native");
            }
            return false;
        }
        catch (InvalidAuthTokenException e) {
            return false;
        }
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        User user;
        String username;
        if (!this.authenticationEnabled) {
            return null;
        }
        ShiroAuthToken shiroAuthToken = (ShiroAuthToken)token;
        try {
            username = AuthToken.safeCast((String)"principal", (Map)shiroAuthToken.getAuthTokenMap());
        }
        catch (InvalidAuthTokenException e) {
            throw new UnsupportedTokenException((Throwable)e);
        }
        try {
            user = this.getUser(username);
        }
        catch (InvalidArgumentsException e) {
            throw new UnknownAccountException();
        }
        return new SystemGraphShiroAuthenticationInfo(user, this.getName());
    }

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        byte[] password;
        SystemGraphShiroAuthenticationInfo ourInfo = (SystemGraphShiroAuthenticationInfo)info;
        User user = ourInfo.getUserRecord();
        try {
            ShiroAuthToken shiroAuthToken = (ShiroAuthToken)token;
            password = AuthToken.safeCastCredentials((String)"credentials", (Map)shiroAuthToken.getAuthTokenMap());
        }
        catch (InvalidAuthTokenException e) {
            throw new UnsupportedTokenException((Throwable)e);
        }
        AuthenticationResult result = this.authenticationStrategy.authenticate(user, password);
        switch (result) {
            case SUCCESS: {
                break;
            }
            case PASSWORD_CHANGE_REQUIRED: {
                break;
            }
            case FAILURE: {
                throw new IncorrectCredentialsException();
            }
            case TOO_MANY_ATTEMPTS: {
                throw new ExcessiveAttemptsException();
            }
            default: {
                throw new AuthenticationException();
            }
        }
        if (user.hasFlag(IS_SUSPENDED)) {
            throw new DisabledAccountException("User '" + user.name() + "' is suspended.");
        }
        if (user.passwordChangeRequired()) {
            result = AuthenticationResult.PASSWORD_CHANGE_REQUIRED;
        }
        ourInfo.setAuthenticationResult(result);
        return true;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (!this.authorizationEnabled) {
            return null;
        }
        String username = (String)this.getAvailablePrincipal(principals);
        if (username == null) {
            return null;
        }
        MutableBoolean existingUser = new MutableBoolean(false);
        MutableBoolean passwordChangeRequired = new MutableBoolean(false);
        MutableBoolean suspended = new MutableBoolean(false);
        TreeSet roleNames = new TreeSet();
        String query = "MATCH (u:User {name: $username}) OPTIONAL MATCH (u)-[:HAS_DB_ROLE]->(:DbRole)-[:FOR_ROLE]->(r:Role) RETURN u.passwordChangeRequired, u.suspended, r.name";
        Map params = MapUtil.map((Object[])new Object[]{"username", username});
        QueryResult.QueryResultVisitor resultVisitor = row -> {
            AnyValue[] fields = row.fields();
            existingUser.setTrue();
            passwordChangeRequired.setValue(((BooleanValue)fields[0]).booleanValue());
            suspended.setValue(((BooleanValue)fields[1]).booleanValue());
            Value role = (Value)fields[2];
            if (role != Values.NO_VALUE) {
                roleNames.add(((TextValue)role).stringValue());
            }
            return true;
        };
        this.systemGraphExecutor.executeQuery(query, params, resultVisitor);
        if (existingUser.isFalse()) {
            return null;
        }
        if (passwordChangeRequired.isTrue() || suspended.isTrue()) {
            return new SimpleAuthorizationInfo();
        }
        return new SimpleAuthorizationInfo(roleNames);
    }

    protected Object getAuthorizationCacheKey(PrincipalCollection principals) {
        return this.getAvailablePrincipal(principals);
    }

    public AuthorizationInfo getAuthorizationInfoSnapshot(PrincipalCollection principalCollection) {
        return this.getAuthorizationInfo(principalCollection);
    }

    public void suspendUser(String username) throws InvalidArgumentsException {
        String query = "MATCH (u:User {name: $name}) SET u.suspended = true RETURN 0";
        Map params = MapUtil.map((Object[])new Object[]{"name", username});
        String errorMsg = "User '" + username + "' does not exist.";
        this.systemGraphExecutor.executeQueryWithParamCheck(query, params, errorMsg);
        this.clearCacheForUser(username);
    }

    public void activateUser(String username, boolean requirePasswordChange) throws InvalidArgumentsException {
        String query = "MATCH (u:User {name: $name}) SET u.suspended = false, u.passwordChangeRequired = $passwordChangeRequired RETURN 0";
        Map params = MapUtil.map((Object[])new Object[]{"name", username, "passwordChangeRequired", requirePasswordChange});
        String errorMsg = "User '" + username + "' does not exist.";
        this.systemGraphExecutor.executeQueryWithParamCheck(query, params, errorMsg);
        this.clearCacheForUser(username);
    }

    public void newRole(String roleName, String ... usernames) throws InvalidArgumentsException {
        this.assertValidRoleName(roleName);
        String query = "CREATE (r:Role {name: $name})";
        Map<String, Object> params = Collections.singletonMap("name", roleName);
        this.systemGraphExecutor.executeQueryWithConstraint(query, params, "The specified role '" + roleName + "' already exists.");
        for (String username : usernames) {
            this.addRoleToUser(roleName, username);
        }
    }

    public boolean deleteRole(String roleName) throws InvalidArgumentsException {
        SystemGraphRealm.assertNotPredefinedRoleName(roleName);
        return this.doDeleteRole(roleName);
    }

    private boolean doDeleteRole(String roleName) throws InvalidArgumentsException {
        String query = "MATCH (r:Role {name: $name}) OPTIONAL MATCH (dbr:DbRole)-[:FOR_ROLE]->(r) DETACH DELETE r, dbr RETURN 0";
        Map params = MapUtil.map((Object[])new Object[]{"name", roleName});
        String errorMsg = "Role '" + roleName + "' does not exist.";
        boolean success = this.systemGraphExecutor.executeQueryWithParamCheck(query, params, errorMsg);
        this.clearCachedAuthorizationInfo();
        return success;
    }

    public void assertRoleExists(String roleName) throws InvalidArgumentsException {
        String query = "MATCH (r:Role {name: $name}) RETURN r.name";
        Map params = MapUtil.map((Object[])new Object[]{"name", roleName});
        String errorMsg = "Role '" + roleName + "' does not exist.";
        this.systemGraphExecutor.executeQueryWithParamCheck(query, params, errorMsg);
    }

    public void addRoleToUser(String roleName, String username) throws InvalidArgumentsException {
        this.addRoleToUserForDb(roleName, "graph.db", username);
    }

    private void addRoleToUserForDb(String roleName, String dbName, String username) throws InvalidArgumentsException {
        this.assertValidRoleName(roleName);
        this.assertValidUsername(username);
        this.assertValidDbName(dbName);
        String query = "MATCH (u:User {name: $user}), (r:Role {name: $role}), (d:Database {name: $db}) OPTIONAL MATCH (u)-[:HAS_DB_ROLE]->(dbr:DbRole)-[:FOR_DATABASE]->(d), (dbr)-[:FOR_ROLE]->(r) WITH u, r, d WHERE dbr IS NULL CREATE (newDbr:DbRole)-[:FOR_ROLE]->(r) CREATE (u)-[:HAS_DB_ROLE]->(newDbr)-[:FOR_DATABASE]->(d) RETURN 0";
        Map params = MapUtil.map((Object[])new Object[]{"user", username, "role", roleName, "db", dbName});
        boolean success = this.systemGraphExecutor.executeQueryWithParamCheck(query, params);
        if (!success) {
            this.getUser(username);
            this.assertRoleExists(roleName);
            this.assertDbExists(dbName);
        }
        this.clearCachedAuthorizationInfoForUser(username);
    }

    public void removeRoleFromUser(String roleName, String username) throws InvalidArgumentsException {
        this.removeRoleFromUserForDb(roleName, "graph.db", username);
    }

    private void removeRoleFromUserForDb(String roleName, String dbName, String username) throws InvalidArgumentsException {
        this.assertValidRoleName(roleName);
        this.assertValidUsername(username);
        this.assertValidDbName(dbName);
        String query = "MATCH (u:User {name: $name})-[:HAS_DB_ROLE]->(dbr:DbRole)-[:FOR_DATABASE]->(:Database {name: $db}), (dbr)-[:FOR_ROLE]->(r:Role {name: $role}) DETACH DELETE dbr RETURN 0 ";
        Map params = MapUtil.map((Object[])new Object[]{"name", username, "role", roleName, "db", dbName});
        boolean success = this.systemGraphExecutor.executeQueryWithParamCheck(query, params);
        if (!success) {
            this.getUser(username);
            this.assertRoleExists(roleName);
            this.assertDbExists(dbName);
        }
        this.clearCachedAuthorizationInfoForUser(username);
    }

    public Set<String> getAllRoleNames() {
        String query = "MATCH (r:Role) RETURN r.name";
        return this.systemGraphExecutor.executeQueryWithResultSet(query);
    }

    public Set<String> getRoleNamesForUser(String username) throws InvalidArgumentsException {
        String query = "MATCH (u:User {name: $username}) OPTIONAL MATCH (u)-[:HAS_DB_ROLE]->(:DbRole)-[:FOR_ROLE]->(r:Role) RETURN r.name";
        Map params = MapUtil.map((Object[])new Object[]{"username", username});
        String errorMsg = "User '" + username + "' does not exist.";
        return this.systemGraphExecutor.executeQueryWithResultSetAndParamCheck(query, params, errorMsg);
    }

    public Set<String> silentlyGetRoleNamesForUser(String username) {
        try {
            return this.getRoleNamesForUser(username);
        }
        catch (InvalidArgumentsException e) {
            return Collections.emptySet();
        }
    }

    public Set<String> getUsernamesForRole(String roleName) throws InvalidArgumentsException {
        String query = "MATCH (r:Role {name: $role}) OPTIONAL MATCH (u:User)-[:HAS_DB_ROLE]->(:DbRole)-[:FOR_ROLE]->(r) RETURN u.name";
        Map params = MapUtil.map((Object[])new Object[]{"role", roleName});
        String errorMsg = "Role '" + roleName + "' does not exist.";
        return this.systemGraphExecutor.executeQueryWithResultSetAndParamCheck(query, params, errorMsg);
    }

    public Set<String> silentlyGetUsernamesForRole(String roleName) {
        try {
            return this.getUsernamesForRole(roleName);
        }
        catch (InvalidArgumentsException e) {
            return Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User newUser(String username, byte[] initialPassword, boolean requirePasswordChange) throws InvalidArgumentsException {
        try {
            this.assertValidUsername(username);
            this.passwordPolicy.validatePassword(initialPassword);
            SystemGraphCredential credential = this.createCredentialForPassword(initialPassword);
            User user = new User.Builder().withName(username).withCredentials((Credential)credential).withRequiredPasswordChange(requirePasswordChange).withoutFlag(IS_SUSPENDED).build();
            this.addUser(user);
            User user2 = user;
            return user2;
        }
        finally {
            if (initialPassword != null) {
                Arrays.fill(initialPassword, (byte)0);
            }
        }
    }

    private void addUser(User user) throws InvalidArgumentsException {
        String query = "CREATE (u:User {name: $name, credentials: $credentials, passwordChangeRequired: $passwordChangeRequired, suspended: $suspended})";
        Map params = MapUtil.map((Object[])new Object[]{"name", user.name(), "credentials", user.credentials().serialize(), "passwordChangeRequired", user.passwordChangeRequired(), "suspended", user.hasFlag(IS_SUSPENDED)});
        this.systemGraphExecutor.executeQueryWithConstraint(query, params, "The specified user '" + user.name() + "' already exists.");
    }

    public boolean deleteUser(String username) throws InvalidArgumentsException {
        String query = "MATCH (u:User {name: $name}) OPTIONAL MATCH (u)-[:HAS_DB_ROLE]->(dbr :DbRole) DETACH DELETE u, dbr RETURN 0";
        Map params = MapUtil.map((Object[])new Object[]{"name", username});
        String errorMsg = "User '" + username + "' does not exist.";
        boolean success = this.systemGraphExecutor.executeQueryWithParamCheck(query, params, errorMsg);
        this.clearCacheForUser(username);
        return success;
    }

    public User getUser(String username) throws InvalidArgumentsException {
        User[] user = new User[1];
        String query = "MATCH (u:User {name: $name}) RETURN u.credentials, u.passwordChangeRequired, u.suspended";
        Map params = MapUtil.map((Object[])new Object[]{"name", username});
        QueryResult.QueryResultVisitor resultVisitor = row -> {
            AnyValue[] fields = row.fields();
            SystemGraphCredential credential = SystemGraphCredential.deserialize(((TextValue)fields[0]).stringValue(), this.secureHasher);
            boolean requirePasswordChange = ((BooleanValue)fields[1]).booleanValue();
            boolean suspended = ((BooleanValue)fields[2]).booleanValue();
            user[0] = suspended ? new User.Builder().withName(username).withCredentials((Credential)credential).withRequiredPasswordChange(requirePasswordChange).withFlag(IS_SUSPENDED).build() : new User.Builder().withName(username).withCredentials((Credential)credential).withRequiredPasswordChange(requirePasswordChange).withoutFlag(IS_SUSPENDED).build();
            return false;
        };
        this.systemGraphExecutor.executeQuery(query, params, resultVisitor);
        if (user[0] == null) {
            throw new InvalidArgumentsException("User '" + username + "' does not exist.");
        }
        return user[0];
    }

    public User silentlyGetUser(String username) {
        try {
            return this.getUser(username);
        }
        catch (InvalidArgumentsException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserPassword(String username, byte[] password, boolean requirePasswordChange) throws InvalidArgumentsException {
        try {
            User existingUser = this.getUser(username);
            this.passwordPolicy.validatePassword(password);
            if (existingUser.credentials().matchesPassword(password)) {
                throw new InvalidArgumentsException("Old password and new password cannot be the same.");
            }
            String newCredentials = SystemGraphCredential.serialize(this.createCredentialForPassword(password));
            String query = "MATCH (u:User {name: $name}) SET u.credentials = $credentials, u.passwordChangeRequired = $passwordChangeRequired RETURN u.name";
            Map params = MapUtil.map((Object[])new Object[]{"name", username, "credentials", newCredentials, "passwordChangeRequired", requirePasswordChange});
            String errorMsg = "User '" + username + "' does not exist.";
            this.systemGraphExecutor.executeQueryWithParamCheck(query, params, errorMsg);
            this.clearCacheForUser(username);
        }
        finally {
            if (password != null) {
                Arrays.fill(password, (byte)0);
            }
        }
    }

    public Set<String> getAllUsernames() {
        String query = "MATCH (u:User) RETURN u.name";
        return this.systemGraphExecutor.executeQueryWithResultSet(query);
    }

    private void newDb(String dbName) throws InvalidArgumentsException {
        this.assertValidDbName(dbName);
        String query = "CREATE (db:Database {name: $dbName})";
        Map<String, Object> params = Collections.singletonMap("dbName", dbName);
        this.systemGraphExecutor.executeQueryWithConstraint(query, params, "The specified database '" + dbName + "' already exists.");
    }

    private void assertDbExists(String dbName) throws InvalidArgumentsException {
        String query = "MATCH (db:Database {name: $name}) RETURN db.name";
        Map params = MapUtil.map((Object[])new Object[]{"name", dbName});
        String errorMsg = "Database '" + dbName + "' does not exist.";
        this.systemGraphExecutor.executeQueryWithParamCheck(query, params, errorMsg);
    }

    protected Set<String> getDbNamesForUser(String username) throws InvalidArgumentsException {
        String query = "MATCH (u:User {name: $username}) OPTIONAL MATCH (u)-[:HAS_DB_ROLE]->(:DbRole)-[:FOR_DATABASE]->(db:Database) RETURN db.name";
        Map params = MapUtil.map((Object[])new Object[]{"username", username});
        String errorMsg = "User '" + username + "' does not exist.";
        return this.systemGraphExecutor.executeQueryWithResultSetAndParamCheck(query, params, errorMsg);
    }

    private static void assertNotPredefinedRoleName(String roleName) throws InvalidArgumentsException {
        if (roleName != null && PredefinedRolesBuilder.roles.keySet().contains(roleName)) {
            throw new InvalidArgumentsException(String.format("'%s' is a predefined role and can not be deleted.", roleName));
        }
    }

    private long numberOfUsers() {
        String query = "MATCH (u:User) RETURN count(u)";
        return this.systemGraphExecutor.executeQueryLong(query);
    }

    private long numberOfRoles() {
        String query = "MATCH (r:Role) RETURN count(r)";
        return this.systemGraphExecutor.executeQueryLong(query);
    }

    private SystemGraphCredential createCredentialForPassword(byte[] password) {
        SimpleHash hash = this.secureHasher.hash(password);
        return new SystemGraphCredential(this.secureHasher, hash);
    }

    private void assertValidUsername(String username) throws InvalidArgumentsException {
        if (username == null || username.isEmpty()) {
            throw new InvalidArgumentsException("The provided username is empty.");
        }
        if (!usernamePattern.matcher(username).matches()) {
            throw new InvalidArgumentsException("Username '" + username + "' contains illegal characters. Use ascii characters that are not ',', ':' or whitespaces.");
        }
    }

    private void assertValidRoleName(String name) throws InvalidArgumentsException {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentsException("The provided role name is empty.");
        }
        if (!roleNamePattern.matcher(name).matches()) {
            throw new InvalidArgumentsException("Role name '" + name + "' contains illegal characters. Use simple ascii characters and numbers.");
        }
    }

    private void assertValidDbName(String name) throws InvalidArgumentsException {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentsException("The provided database name is empty.");
        }
    }

    private void clearCachedAuthorizationInfoForUser(String username) {
        this.clearCachedAuthorizationInfo((PrincipalCollection)new SimplePrincipalCollection((Object)username, this.getName()));
    }

    private void clearCacheForUser(String username) {
        this.clearCache((PrincipalCollection)new SimplePrincipalCollection((Object)username, this.getName()));
    }

    private void clearCachedAuthorizationInfo() {
        Cache cache = this.getAuthorizationCache();
        if (cache != null) {
            cache.clear();
        }
    }

    private void initializeSystemGraph() throws Throwable {
        if (this.isSystemGraphEmpty()) {
            QueryResult.QueryResultVisitor resultVisitor = row -> true;
            this.systemGraphExecutor.executeQuery("CREATE CONSTRAINT ON (u:User) ASSERT u.name IS UNIQUE", Collections.emptyMap(), resultVisitor);
            this.systemGraphExecutor.executeQuery("CREATE CONSTRAINT ON (r:Role) ASSERT r.name IS UNIQUE", Collections.emptyMap(), resultVisitor);
            this.systemGraphExecutor.executeQuery("CREATE CONSTRAINT ON (d:Database) ASSERT d.name IS UNIQUE", Collections.emptyMap(), resultVisitor);
            this.ensureDefaultDatabases();
            if (this.importOptions.shouldPerformImport) {
                this.importUsersAndRoles();
            } else if (this.importOptions.mayPerformMigration) {
                this.migrateFromFlatFileRealm();
            }
        } else if (this.importOptions.shouldPerformImport) {
            this.importUsersAndRoles();
        }
        this.ensureDefaultUsersAndRoles();
    }

    private boolean isSystemGraphEmpty() {
        String query = "MATCH (db:Database {name: $name}) RETURN db.name";
        Map params = MapUtil.map((Object[])new Object[]{"name", "system.db"});
        return !this.systemGraphExecutor.executeQueryWithParamCheck(query, params);
    }

    private void ensureDefaultUsersAndRoles() throws Throwable {
        Set<String> addedDefaultUsers = this.ensureDefaultUsers();
        this.ensureDefaultRoles(addedDefaultUsers);
    }

    private void ensureDefaultDatabases() throws InvalidArgumentsException {
        this.newDb("graph.db");
        this.newDb("system.db");
    }

    private UserRepository startUserRepository(Supplier<UserRepository> supplier) throws Throwable {
        UserRepository userRepository = supplier.get();
        userRepository.init();
        userRepository.start();
        return userRepository;
    }

    private void stopUserRepository(UserRepository userRepository) throws Throwable {
        userRepository.stop();
        userRepository.shutdown();
    }

    private RoleRepository startRoleRepository(Supplier<RoleRepository> supplier) throws Throwable {
        RoleRepository roleRepository = supplier.get();
        roleRepository.init();
        roleRepository.start();
        return roleRepository;
    }

    private void stopRoleRepository(RoleRepository roleRepository) throws Throwable {
        roleRepository.stop();
        roleRepository.shutdown();
    }

    private Set<String> ensureDefaultUsers() throws Throwable {
        if (this.numberOfUsers() == 0L) {
            TreeSet<String> addedUsernames = new TreeSet<String>();
            if (this.importOptions.initialUserRepositorySupplier != null) {
                User initialUser;
                UserRepository initialUserRepository = this.startUserRepository(this.importOptions.initialUserRepositorySupplier);
                if (initialUserRepository.numberOfUsers() > 0 && (initialUser = initialUserRepository.getUserByName("neo4j")) != null) {
                    this.addUser(initialUser);
                    addedUsernames.add(initialUser.name());
                }
                this.stopUserRepository(initialUserRepository);
            }
            if (addedUsernames.isEmpty()) {
                this.newUser("neo4j", UTF8.encode((String)"neo4j"), true);
                addedUsernames.add("neo4j");
            }
            return addedUsernames;
        }
        return Collections.emptySet();
    }

    private void ensureDefaultRoles(Set<String> addedDefaultUsers) throws Throwable {
        LinkedList<String> newAdmins = new LinkedList<String>(addedDefaultUsers);
        if (this.numberOfRoles() == 0L) {
            if (newAdmins.isEmpty()) {
                String newAdminUsername = null;
                if (this.importOptions.defaultAdminRepositorySupplier != null) {
                    UserRepository defaultAdminRepository = this.startUserRepository(this.importOptions.defaultAdminRepositorySupplier);
                    int numberOfDefaultAdmins = defaultAdminRepository.numberOfUsers();
                    if (numberOfDefaultAdmins > 1) {
                        throw new InvalidArgumentsException("No roles defined, and multiple users defined as default admin user. Please use `neo4j-admin set-default-admin` to select a valid admin.");
                    }
                    newAdminUsername = numberOfDefaultAdmins == 0 ? null : (String)defaultAdminRepository.getAllUsernames().iterator().next();
                    this.stopUserRepository(defaultAdminRepository);
                }
                Set<String> usernames = this.getAllUsernames();
                if (newAdminUsername != null) {
                    if (this.silentlyGetUser(newAdminUsername) == null) {
                        throw new InvalidArgumentsException("No roles defined, and default admin user '" + newAdminUsername + "' does not exist. Please use `neo4j-admin " + "set-default-admin" + "` to select a valid admin.");
                    }
                    newAdmins.add(newAdminUsername);
                } else if (usernames.size() == 1) {
                    newAdmins.add(usernames.iterator().next());
                } else if (usernames.contains("neo4j")) {
                    newAdmins.add("neo4j");
                } else {
                    throw new InvalidArgumentsException("No roles defined, and cannot determine which user should be admin. Please use `neo4j-admin set-default-admin` to select an admin.");
                }
            }
            for (String role : PredefinedRolesBuilder.roles.keySet()) {
                this.newRole(role, new String[0]);
            }
        }
        for (String username : newAdmins) {
            this.addRoleToUser("admin", username);
            this.securityLog.info("Assigned %s role to user '%s'.", new Object[]{"admin", username});
        }
    }

    private void migrateFromFlatFileRealm() throws Throwable {
        RoleRepository roleRepository;
        UserRepository userRepository = this.startUserRepository(this.importOptions.migrationUserRepositorySupplier);
        if (!this.doImportUsersAndRoles(userRepository, roleRepository = this.startRoleRepository(this.importOptions.migrationRoleRepositorySupplier), false)) {
            throw new InvalidArgumentsException("Automatic migration of users and roles into system graph failed because repository files are inconsistent. Please use `neo4j-admin import-auth` to perform migration manually.");
        }
        this.stopUserRepository(userRepository);
        this.stopRoleRepository(roleRepository);
    }

    private void importUsersAndRoles() throws Throwable {
        RoleRepository roleRepository;
        UserRepository userRepository = this.startUserRepository(this.importOptions.importUserRepositorySupplier);
        if (!this.doImportUsersAndRoles(userRepository, roleRepository = this.startRoleRepository(this.importOptions.importRoleRepositorySupplier), this.importOptions.shouldPurgeImportRepositoriesAfterSuccesfulImport)) {
            throw new InvalidArgumentsException("Import of users and roles into system graph failed because the import files are inconsistent. Please use `neo4j-admin import-auth` to retry import again.");
        }
        this.stopUserRepository(userRepository);
        this.stopRoleRepository(roleRepository);
    }

    private boolean doImportUsersAndRoles(UserRepository userRepository, RoleRepository roleRepository, boolean purgeOnSuccess) throws Throwable {
        ListSnapshot users = userRepository.getPersistedSnapshot();
        ListSnapshot roles = roleRepository.getPersistedSnapshot();
        boolean isEmpty = users.values().isEmpty() && roles.values().isEmpty();
        boolean valid = RoleRepository.validate((List)users.values(), (List)roles.values());
        if (!valid) {
            return false;
        }
        if (!isEmpty) {
            String roleString;
            String userString;
            Pair<Integer, Integer> numberOfDeletedUsersAndRoles = Pair.of((Object)0, (Object)0);
            try (Transaction transaction = this.systemGraphExecutor.systemDbBeginTransaction();){
                if (this.importOptions.shouldResetSystemGraphAuthBeforeImport) {
                    numberOfDeletedUsersAndRoles = this.deleteAllSystemGraphAuthData();
                }
                for (User user : users.values()) {
                    this.addUser(user);
                }
                for (RoleRecord role : roles.values()) {
                    this.newRole(role.name(), new String[0]);
                    for (String username : role.users()) {
                        this.addRoleToUser(role.name(), username);
                    }
                }
                transaction.success();
            }
            assert (this.validateImportSucceeded(userRepository, roleRepository));
            if (this.importOptions.shouldResetSystemGraphAuthBeforeImport) {
                userString = (Integer)numberOfDeletedUsersAndRoles.first() == 1 ? "user" : "users";
                roleString = (Integer)numberOfDeletedUsersAndRoles.other() == 1 ? "role" : "roles";
                this.securityLog.info("Deleted %s %s and %s %s into system graph.", new Object[]{Integer.toString((Integer)numberOfDeletedUsersAndRoles.first()), userString, Integer.toString((Integer)numberOfDeletedUsersAndRoles.other()), roleString});
            }
            userString = users.values().size() == 1 ? "user" : "users";
            roleString = roles.values().size() == 1 ? "role" : "roles";
            this.securityLog.info("Completed import of %s %s and %s %s into system graph.", new Object[]{Integer.toString(users.values().size()), userString, Integer.toString(roles.values().size()), roleString});
        }
        if (purgeOnSuccess) {
            userRepository.purge();
            roleRepository.purge();
            this.securityLog.debug("Source import user and role repositories were purged.");
        }
        return true;
    }

    private Pair<Integer, Integer> deleteAllSystemGraphAuthData() throws InvalidArgumentsException {
        Set<String> usernames = this.getAllUsernames();
        for (String username : usernames) {
            this.deleteUser(username);
        }
        Set<String> roleNames = this.getAllRoleNames();
        for (String roleName : roleNames) {
            this.doDeleteRole(roleName);
        }
        return Pair.of((Object)usernames.size(), (Object)roleNames.size());
    }

    private boolean validateImportSucceeded(UserRepository userRepository, RoleRepository roleRepository) throws Throwable {
        ListSnapshot users = userRepository.getPersistedSnapshot();
        ListSnapshot roles = roleRepository.getPersistedSnapshot();
        try (Transaction transaction = this.systemGraphExecutor.systemDbBeginTransaction();){
            Set<String> systemGraphUsers = this.getAllUsernames();
            List repoUsernames = users.values().stream().map(u -> u.name()).collect(Collectors.toList());
            if (!systemGraphUsers.containsAll(repoUsernames)) {
                throw new IOException("Users were not imported correctly");
            }
            List repoRoleNames = roles.values().stream().map(r -> r.name()).collect(Collectors.toList());
            Set<String> systemGraphRoles = this.getAllRoleNames();
            if (!systemGraphRoles.containsAll(repoRoleNames)) {
                throw new IOException("Roles were not imported correctly");
            }
            for (RoleRecord role : roles.values()) {
                Set<String> usernamesForRole = this.getUsernamesForRole(role.name());
                if (usernamesForRole.containsAll(role.users())) continue;
                throw new IOException("Role assignments were not imported correctly");
            }
            transaction.success();
        }
        return true;
    }
}

