/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

public class Mark {
    public static final int END_OF_LINE_CHARACTER = -1;
    private int startPosition;
    private int position;
    private int character;
    private boolean quoted;

    void set(int startPosition, int position2, int character, boolean quoted) {
        this.startPosition = startPosition;
        this.position = position2;
        this.character = character;
        this.quoted = quoted;
    }

    public int character() {
        assert (!this.isEndOfLine());
        return this.character;
    }

    public boolean isEndOfLine() {
        return this.character == -1;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    int position() {
        if (this.position == -1) {
            throw new IllegalStateException("No value to extract here");
        }
        return this.position;
    }

    int startPosition() {
        if (this.startPosition == -1) {
            throw new IllegalStateException("No value to extract here");
        }
        return this.startPosition;
    }

    int length() {
        return this.position - this.startPosition;
    }

    public String toString() {
        return String.format("Mark[from:%d, to:%d, quoted:%b]", this.startPosition, this.position, this.quoted);
    }
}

