/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.BufferedCharSeeker;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Magic;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.csv.reader.WrappedCharReadable;
import org.neo4j.function.IOFunction;
import org.neo4j.function.ThrowingFunction;

public class Readables {
    public static final CharReadable EMPTY = new CharReadable.Adapter(){

        @Override
        public SectionedCharBuffer read(SectionedCharBuffer buffer, int from2) {
            return buffer;
        }

        @Override
        public void close() {
        }

        @Override
        public String sourceDescription() {
            return "EMPTY";
        }

        @Override
        public int read(char[] into, int offset, int length2) {
            return -1;
        }

        @Override
        public long length() {
            return 0L;
        }
    };

    private Readables() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static CharReadable wrap(InputStream stream, String sourceName, Charset charset) throws IOException {
        return Readables.wrap(stream, sourceName, charset, 0L);
    }

    public static CharReadable wrap(InputStream stream, final String sourceName, Charset charset, long length2) throws IOException {
        byte[] bytes2 = new byte[Magic.longest()];
        PushbackInputStream pushbackStream = new PushbackInputStream(stream, bytes2.length);
        Charset usedCharset = charset;
        int read = stream.read(bytes2);
        if (read >= 0) {
            bytes2 = read < bytes2.length ? Arrays.copyOf(bytes2, read) : bytes2;
            Magic magic = Magic.of(bytes2);
            int excessiveBytes = read;
            if (magic.impliesEncoding()) {
                excessiveBytes -= magic.length();
                usedCharset = magic.encoding();
            }
            pushbackStream.unread(bytes2, read - excessiveBytes, excessiveBytes);
        }
        return Readables.wrap(new InputStreamReader(pushbackStream, usedCharset){

            public String toString() {
                return sourceName;
            }
        }, length2);
    }

    public static CharReadable wrap(String data) {
        return Readables.wrap(new StringReader(data), data.length());
    }

    public static CharReadable wrap(Reader reader, long length2) {
        return new WrappedCharReadable(length2, reader);
    }

    private static boolean invalidZipEntry(String name) {
        return name.contains("__MACOSX") || name.startsWith(".") || name.contains("/.");
    }

    public static RawIterator<CharReadable, IOException> individualFiles(Charset charset, File ... files2) {
        return Readables.iterator(new FromFile(charset), files2);
    }

    public static CharReadable files(Charset charset, File ... files2) throws IOException {
        FromFile opener = new FromFile(charset);
        switch (files2.length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return (CharReadable)opener.apply(files2[0]);
            }
        }
        return new MultiReadable(Readables.iterator(opener, files2));
    }

    @SafeVarargs
    public static <IN, OUT> RawIterator<OUT, IOException> iterator(final ThrowingFunction<IN, OUT, IOException> converter, final IN ... items) {
        if (items.length == 0) {
            throw new IllegalStateException("No source items specified");
        }
        return new RawIterator<OUT, IOException>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor < items.length;
            }

            @Override
            public OUT next() throws IOException {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                return converter.apply(items[this.cursor++]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static char[] extractFirstLineFrom(CharReadable source) throws IOException {
        int read;
        char[] result2 = new char[100];
        int cursor = 0;
        boolean foundEol = false;
        do {
            if (cursor >= result2.length) {
                result2 = Arrays.copyOf(result2, cursor * 2);
            }
            if ((read = source.read(result2, cursor, 1)) <= 0 || (foundEol = BufferedCharSeeker.isEolChar(result2[cursor]))) continue;
            ++cursor;
        } while (read > 0 && !foundEol);
        return Arrays.copyOf(result2, cursor);
    }

    private static class FromFile
    implements IOFunction<File, CharReadable> {
        private final Charset charset;

        FromFile(Charset charset) {
            this.charset = charset;
        }

        @Override
        public CharReadable apply(final File file) throws IOException {
            Magic magic = Magic.of(file);
            if (magic == Magic.ZIP) {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry entry = this.getSingleSuitableEntry(zipFile);
                return Readables.wrap(new InputStreamReader(zipFile.getInputStream(entry), this.charset){

                    public String toString() {
                        return file.getPath();
                    }
                }, file.length());
            }
            if (magic == Magic.GZIP) {
                GZIPInputStream zipStream = new GZIPInputStream(new FileInputStream(file));
                return Readables.wrap(new InputStreamReader(zipStream, this.charset){

                    public String toString() {
                        return file.getPath();
                    }
                }, file.length());
            }
            FileInputStream in2 = new FileInputStream(file);
            Charset usedCharset = this.charset;
            if (magic.impliesEncoding()) {
                ((InputStream)in2).skip(magic.length());
                usedCharset = magic.encoding();
            }
            return Readables.wrap(new InputStreamReader(in2, usedCharset){

                public String toString() {
                    return file.getPath();
                }
            }, file.length());
        }

        private ZipEntry getSingleSuitableEntry(ZipFile zipFile) throws IOException {
            ArrayList<String> unsuitableEntries = new ArrayList<String>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ZipEntry found = null;
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                if (entry.isDirectory() || Readables.invalidZipEntry(entry.getName())) {
                    unsuitableEntries.add(entry.getName());
                    continue;
                }
                if (found != null) {
                    throw new IOException("Multiple suitable files found in zip file " + zipFile.getName() + ", at least " + found.getName() + " and " + entry.getName() + ". Only a single file per zip file is supported");
                }
                found = entry;
            }
            if (found == null) {
                throw new IOException("No suitable file found in zip file " + zipFile.getName() + "." + (!unsuitableEntries.isEmpty() ? " Although found these unsuitable entries " + unsuitableEntries : ""));
            }
            return found;
        }
    }
}

