/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import java.io.Reader;

public class SectionedCharBuffer {
    private final char[] buffer;
    private final int pivot;
    private int back;
    private int front;

    public SectionedCharBuffer(int effectiveBuffserSize) {
        this.buffer = new char[effectiveBuffserSize * 2];
        this.front = this.pivot = effectiveBuffserSize;
        this.back = this.pivot;
    }

    public char[] array() {
        return this.buffer;
    }

    public void compact(SectionedCharBuffer into, int from2) {
        assert (this.buffer.length == into.buffer.length);
        int diff2 = this.front - from2;
        into.back = this.pivot - diff2;
        System.arraycopy(this.buffer, from2, into.buffer, into.back, diff2);
    }

    public void readFrom(Reader reader) throws IOException {
        this.readFrom(reader, this.pivot);
    }

    public void readFrom(Reader reader, int max2) throws IOException {
        int read = reader.read(this.buffer, this.pivot, Math.min(max2, this.pivot));
        this.front = read == -1 ? this.pivot : this.pivot + read;
    }

    public void append(char ch) {
        this.buffer[this.front++] = ch;
    }

    public int pivot() {
        return this.pivot;
    }

    public int back() {
        return this.back;
    }

    public int front() {
        return this.front;
    }

    public boolean hasAvailable() {
        return this.front > this.pivot;
    }

    public int available() {
        return this.front - this.pivot;
    }
}

