/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.csv.reader.ThreadAhead;

public class ThreadAheadReadable
extends ThreadAhead
implements CharReadable {
    private final CharReadable actual;
    private SectionedCharBuffer theOtherBuffer;
    private String sourceDescription;
    private String newSourceDescription;

    private ThreadAheadReadable(CharReadable actual2, int bufferSize) {
        super(actual2);
        this.actual = actual2;
        this.theOtherBuffer = new SectionedCharBuffer(bufferSize);
        this.sourceDescription = actual2.sourceDescription();
        this.start();
    }

    @Override
    public SectionedCharBuffer read(SectionedCharBuffer buffer, int from2) throws IOException {
        this.waitUntilReadAhead();
        SectionedCharBuffer resultBuffer = this.theOtherBuffer;
        buffer.compact(resultBuffer, from2);
        this.theOtherBuffer = buffer;
        if (this.newSourceDescription != null) {
            this.sourceDescription = this.newSourceDescription;
            this.newSourceDescription = null;
        }
        this.pokeReader();
        return resultBuffer;
    }

    @Override
    public int read(char[] into, int offset, int length2) {
        throw new UnsupportedOperationException("Unsupported for now");
    }

    @Override
    protected boolean readAhead() throws IOException {
        this.theOtherBuffer = this.actual.read(this.theOtherBuffer, this.theOtherBuffer.front());
        String sourceDescriptionAfterRead = this.actual.sourceDescription();
        if (!this.sourceDescription.equals(sourceDescriptionAfterRead)) {
            this.newSourceDescription = sourceDescriptionAfterRead;
        }
        return this.theOtherBuffer.hasAvailable();
    }

    @Override
    public long position() {
        return this.actual.position();
    }

    @Override
    public String sourceDescription() {
        return this.sourceDescription;
    }

    public static CharReadable threadAhead(CharReadable actual2, int bufferSize) {
        return new ThreadAheadReadable(actual2, bufferSize);
    }

    @Override
    public long length() {
        return this.actual.length();
    }
}

