/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.NumericHelper;
import org.neo4j.cypher.internal.v3_5.util.CypherTypeException;
import org.neo4j.cypher.internal.v3_5.util.CypherTypeException$;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class NumericHelper$class {
    public static Option asLongEntityId(NumericHelper $this, AnyValue a) {
        Option option;
        AnyValue anyValue = a;
        if (anyValue instanceof IntegralValue) {
            IntegralValue integralValue = (IntegralValue)anyValue;
            option = new Some<Long>(BoxesRunTime.boxToLong(integralValue.longValue()));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public static DoubleValue asDouble(NumericHelper $this, AnyValue a) {
        return Values.doubleValue(NumericHelper$class.asNumber($this, a).doubleValue());
    }

    public static IntValue asInt(NumericHelper $this, AnyValue a) {
        return Values.intValue($this.asPrimitiveInt(a));
    }

    public static int asPrimitiveInt(NumericHelper $this, AnyValue a) {
        return (int)NumericHelper$class.asNumber($this, a).longValue();
    }

    public static LongValue asLong(NumericHelper $this, AnyValue a) {
        return Values.longValue($this.asPrimitiveLong(a));
    }

    public static long asPrimitiveLong(NumericHelper $this, AnyValue a) {
        return NumericHelper$class.asNumber($this, a).longValue();
    }

    private static NumberValue asNumber(NumericHelper $this, AnyValue a) {
        AnyValue anyValue = a;
        if (anyValue == null) {
            throw new CypherTypeException(new StringBuilder().append((Object)"Expected a numeric value for ").append((Object)$this.toString()).append((Object)", but got null").toString(), CypherTypeException$.MODULE$.$lessinit$greater$default$2());
        }
        Value value2 = Values.NO_VALUE;
        AnyValue anyValue2 = anyValue;
        if (!(value2 != null ? !((Object)value2).equals(anyValue2) : anyValue2 != null)) {
            throw new CypherTypeException(new StringBuilder().append((Object)"Expected a numeric value for ").append((Object)$this.toString()).append((Object)", but got null").toString(), CypherTypeException$.MODULE$.$lessinit$greater$default$2());
        }
        if (anyValue instanceof NumberValue) {
            NumberValue numberValue;
            NumberValue numberValue2 = numberValue = (NumberValue)anyValue;
            return numberValue2;
        }
        throw new CypherTypeException(new StringBuilder().append((Object)"Expected a numeric value for ").append((Object)$this.toString()).append((Object)", but got: ").append((Object)a.toString()).toString(), CypherTypeException$.MODULE$.$lessinit$greater$default$2());
    }

    public static void $init$(NumericHelper $this) {
    }
}

