/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.diagnostics;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.diagnostics.DiagnosticsReportSource;
import org.neo4j.diagnostics.DiagnosticsReporterProgress;
import org.neo4j.diagnostics.ProgressAwareInputStream;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;

public class DiagnosticsReportSources {
    private DiagnosticsReportSources() {
        throw new AssertionError((Object)"No instances");
    }

    public static DiagnosticsReportSource newDiagnosticsFile(String destination, FileSystemAbstraction fs, File source) {
        return new DiagnosticsFileReportSource(destination, fs, source);
    }

    public static List<DiagnosticsReportSource> newDiagnosticsRotatingFile(String destination, FileSystemAbstraction fs, File file) {
        ArrayList<DiagnosticsReportSource> files2 = new ArrayList<DiagnosticsReportSource>();
        files2.add(DiagnosticsReportSources.newDiagnosticsFile(destination, fs, file));
        List<File> allArchives = RotatingFileOutputStreamSupplier.getAllArchives(fs, file);
        for (File archive : allArchives) {
            String name = archive.getName();
            String n = name.substring(name.lastIndexOf(46));
            files2.add(DiagnosticsReportSources.newDiagnosticsFile(destination + "." + n, fs, archive));
        }
        return files2;
    }

    public static DiagnosticsReportSource newDiagnosticsString(String destination, Supplier<String> messageSupplier) {
        return new DiagnosticsStringReportSource(destination, messageSupplier);
    }

    private static class DiagnosticsStringReportSource
    implements DiagnosticsReportSource {
        private final String destination;
        private final Supplier<String> messageSupplier;

        private DiagnosticsStringReportSource(String destination, Supplier<String> messageSupplier) {
            this.destination = destination;
            this.messageSupplier = messageSupplier;
        }

        @Override
        public String destinationPath() {
            return this.destination;
        }

        @Override
        public void addToArchive(Path archiveDestination, DiagnosticsReporterProgress progress) throws IOException {
            String message = this.messageSupplier.get();
            Files.write(archiveDestination, message.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }

        @Override
        public long estimatedSize(DiagnosticsReporterProgress progress) {
            return 0L;
        }
    }

    private static class DiagnosticsFileReportSource
    implements DiagnosticsReportSource {
        private final String destination;
        private final FileSystemAbstraction fs;
        private final File source;

        DiagnosticsFileReportSource(String destination, FileSystemAbstraction fs, File source) {
            this.destination = destination;
            this.fs = fs;
            this.source = source;
        }

        @Override
        public String destinationPath() {
            return this.destination;
        }

        @Override
        public void addToArchive(Path archiveDestination, DiagnosticsReporterProgress progress) throws IOException {
            long size2 = this.fs.getFileSize(this.source);
            InputStream in2 = this.fs.openAsInputStream(this.source);
            try (ProgressAwareInputStream inStream = new ProgressAwareInputStream(in2, size2, progress::percentChanged);){
                Files.copy(inStream, archiveDestination, new CopyOption[0]);
            }
        }

        @Override
        public long estimatedSize(DiagnosticsReporterProgress progress) {
            return this.fs.getFileSize(this.source);
        }
    }
}

