/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.StatementResultCursor;
import org.neo4j.driver.v1.StatementRunner;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.types.TypeSystem;

abstract class AbstractStatementRunner
implements StatementRunner {
    AbstractStatementRunner() {
    }

    @Override
    public final StatementResult run(String statementTemplate, Value parameters) {
        return this.run(new Statement(statementTemplate, parameters));
    }

    @Override
    public final CompletionStage<StatementResultCursor> runAsync(String statementTemplate, Value parameters) {
        return this.runAsync(new Statement(statementTemplate, parameters));
    }

    @Override
    public final StatementResult run(String statementTemplate, Map<String, Object> statementParameters) {
        return this.run(statementTemplate, AbstractStatementRunner.parameters(statementParameters));
    }

    @Override
    public final CompletionStage<StatementResultCursor> runAsync(String statementTemplate, Map<String, Object> statementParameters) {
        return this.runAsync(statementTemplate, AbstractStatementRunner.parameters(statementParameters));
    }

    @Override
    public final StatementResult run(String statementTemplate, Record statementParameters) {
        return this.run(statementTemplate, AbstractStatementRunner.parameters(statementParameters));
    }

    @Override
    public final CompletionStage<StatementResultCursor> runAsync(String statementTemplate, Record statementParameters) {
        return this.runAsync(statementTemplate, AbstractStatementRunner.parameters(statementParameters));
    }

    @Override
    public final StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public final CompletionStage<StatementResultCursor> runAsync(String statementText) {
        return this.runAsync(statementText, Values.EmptyMap);
    }

    @Override
    public final TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    private static Value parameters(Record record) {
        return record == null ? Values.EmptyMap : AbstractStatementRunner.parameters(record.asMap());
    }

    private static Value parameters(Map<String, Object> map2) {
        if (map2 == null || map2.isEmpty()) {
            return Values.EmptyMap;
        }
        return new MapValue(Extract.mapOfValues(map2));
    }
}

