/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.internal.InternalEntity;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.types.Node;

public class InternalNode
extends InternalEntity
implements Node {
    private final Collection<String> labels;

    public InternalNode(long id2) {
        this(id2, Collections.emptyList(), Collections.emptyMap());
    }

    public InternalNode(long id2, Collection<String> labels2, Map<String, Value> properties) {
        super(id2, properties);
        this.labels = labels2;
    }

    public Collection<String> labels() {
        return this.labels;
    }

    @Override
    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }

    @Override
    public Value asValue() {
        return new NodeValue(this);
    }

    @Override
    public String toString() {
        return String.format("node<%s>", this.id());
    }
}

