/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Objects;
import org.neo4j.driver.v1.util.Pair;

public class InternalPair<K, V>
implements Pair<K, V> {
    private final K key;
    private final V value;

    protected InternalPair(K key, V value2) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value2);
        this.key = key;
        this.value = value2;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public V value() {
        return this.value;
    }

    public static <K, V> Pair<K, V> of(K key, V value2) {
        return new InternalPair<K, V>(key, value2);
    }

    public String toString() {
        return String.format("%s: %s", Objects.toString(this.key), Objects.toString(this.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalPair that = (InternalPair)o;
        return this.key.equals(that.key) && this.value.equals(that.value);
    }

    public int hashCode() {
        int result2 = this.key.hashCode();
        result2 = 31 * result2 + this.value.hashCode();
        return result2;
    }
}

