/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.internal.InternalEntity;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.types.Relationship;

public class InternalRelationship
extends InternalEntity
implements Relationship {
    private long start;
    private long end;
    private final String type;

    public InternalRelationship(long id2, long start, long end, String type) {
        this(id2, start, end, type, Collections.emptyMap());
    }

    public InternalRelationship(long id2, long start, long end, String type, Map<String, Value> properties) {
        super(id2, properties);
        this.start = start;
        this.end = end;
        this.type = type;
    }

    @Override
    public boolean hasType(String relationshipType) {
        return this.type().equals(relationshipType);
    }

    public void setStartAndEnd(long start, long end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public long startNodeId() {
        return this.start;
    }

    @Override
    public long endNodeId() {
        return this.end;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public Value asValue() {
        return new RelationshipValue(this);
    }

    @Override
    public String toString() {
        return String.format("relationship<%s>", this.id());
    }
}

