/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.internal.NetworkSession;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logging;

class LeakLoggingNetworkSession
extends NetworkSession {
    private final String stackTrace = LeakLoggingNetworkSession.captureStackTrace();

    LeakLoggingNetworkSession(ConnectionProvider connectionProvider, AccessMode mode, RetryLogic retryLogic, Logging logging) {
        super(connectionProvider, mode, retryLogic, logging);
    }

    protected void finalize() throws Throwable {
        this.logLeakIfNeeded();
        super.finalize();
    }

    private void logLeakIfNeeded() {
        Boolean isOpen = Futures.blockingGet(this.currentConnectionIsOpen());
        if (isOpen.booleanValue()) {
            this.logger.error("Neo4j Session object leaked, please ensure that your applicationcalls the `close` method on Sessions before disposing of the objects.\nSession was create at:\n" + this.stackTrace, null);
        }
    }

    private static String captureStackTrace() {
        StackTraceElement[] elements;
        StringBuilder result2 = new StringBuilder();
        for (StackTraceElement element : elements = Thread.currentThread().getStackTrace()) {
            result2.append("\t").append(element).append(System.lineSeparator());
        }
        return result2.toString();
    }
}

