/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster.loadbalancing;

import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.RoundRobinArrayIndex;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class LeastConnectedLoadBalancingStrategy
implements LoadBalancingStrategy {
    private static final String LOGGER_NAME = LeastConnectedLoadBalancingStrategy.class.getSimpleName();
    private final RoundRobinArrayIndex readersIndex = new RoundRobinArrayIndex();
    private final RoundRobinArrayIndex writersIndex = new RoundRobinArrayIndex();
    private final ConnectionPool connectionPool;
    private final Logger log;

    public LeastConnectedLoadBalancingStrategy(ConnectionPool connectionPool, Logging logging) {
        this.connectionPool = connectionPool;
        this.log = logging.getLog(LOGGER_NAME);
    }

    @Override
    public BoltServerAddress selectReader(BoltServerAddress[] knownReaders) {
        return this.select(knownReaders, this.readersIndex, "reader");
    }

    @Override
    public BoltServerAddress selectWriter(BoltServerAddress[] knownWriters) {
        return this.select(knownWriters, this.writersIndex, "writer");
    }

    private BoltServerAddress select(BoltServerAddress[] addresses, RoundRobinArrayIndex addressesIndex, String addressType) {
        int startIndex;
        int size2 = addresses.length;
        if (size2 == 0) {
            this.log.trace("Unable to select %s, no known addresses given", addressType);
            return null;
        }
        int index = startIndex = addressesIndex.next(size2);
        BoltServerAddress leastConnectedAddress = null;
        int leastActiveConnections = Integer.MAX_VALUE;
        do {
            BoltServerAddress address;
            int activeConnections;
            if ((activeConnections = this.connectionPool.inUseConnections(address = addresses[index])) < leastActiveConnections) {
                leastConnectedAddress = address;
                leastActiveConnections = activeConnections;
            }
            if (index == size2 - 1) {
                index = 0;
                continue;
            }
            ++index;
        } while (index != startIndex);
        this.log.trace("Selected %s with address: '%s' and active connections: %s", addressType, leastConnectedAddress, leastActiveConnections);
        return leastConnectedAddress;
    }
}

