/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import java.util.logging.Level;
import java.util.logging.Logger;

public class JULogger
implements org.neo4j.driver.v1.Logger {
    private final Logger delegate;
    private final boolean debugEnabled;
    private final boolean traceEnabled;

    public JULogger(String name, Level loggingLevel) {
        this.delegate = Logger.getLogger(name);
        this.delegate.setLevel(loggingLevel);
        this.debugEnabled = this.delegate.isLoggable(Level.FINE);
        this.traceEnabled = this.delegate.isLoggable(Level.FINEST);
    }

    @Override
    public void error(String message, Throwable cause) {
        this.delegate.log(Level.SEVERE, message, cause);
    }

    @Override
    public void info(String format2, Object ... params2) {
        this.delegate.log(Level.INFO, String.format(format2, params2));
    }

    @Override
    public void warn(String format2, Object ... params2) {
        this.delegate.log(Level.WARNING, String.format(format2, params2));
    }

    @Override
    public void warn(String message, Throwable cause) {
        this.delegate.log(Level.WARNING, message, cause);
    }

    @Override
    public void debug(String format2, Object ... params2) {
        if (this.debugEnabled) {
            this.delegate.log(Level.FINE, String.format(format2, params2));
        }
    }

    @Override
    public void trace(String format2, Object ... params2) {
        if (this.traceEnabled) {
            this.delegate.log(Level.FINEST, String.format(format2, params2));
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }
}

