/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v1;

import java.io.IOException;
import java.util.Map;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.ResponseMessageHandler;
import org.neo4j.driver.internal.messaging.ValueUnpacker;
import org.neo4j.driver.internal.messaging.v1.ValueUnpackerV1;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.v1.Value;

public class MessageReaderV1
implements MessageFormat.Reader {
    private final ValueUnpacker unpacker;

    public MessageReaderV1(PackInput input2) {
        this(new ValueUnpackerV1(input2));
    }

    protected MessageReaderV1(ValueUnpacker unpacker) {
        this.unpacker = unpacker;
    }

    @Override
    public void read(ResponseMessageHandler handler) throws IOException {
        this.unpacker.unpackStructHeader();
        int type = this.unpacker.unpackStructSignature();
        switch (type) {
            case 112: {
                this.unpackSuccessMessage(handler);
                break;
            }
            case 127: {
                this.unpackFailureMessage(handler);
                break;
            }
            case 126: {
                this.unpackIgnoredMessage(handler);
                break;
            }
            case 113: {
                this.unpackRecordMessage(handler);
                break;
            }
            default: {
                throw new IOException("Unknown message type: " + type);
            }
        }
    }

    private void unpackSuccessMessage(ResponseMessageHandler output) throws IOException {
        Map<String, Value> map2 = this.unpacker.unpackMap();
        output.handleSuccessMessage(map2);
    }

    private void unpackFailureMessage(ResponseMessageHandler output) throws IOException {
        Map<String, Value> params2 = this.unpacker.unpackMap();
        String code = params2.get("code").asString();
        String message = params2.get("message").asString();
        output.handleFailureMessage(code, message);
    }

    private void unpackIgnoredMessage(ResponseMessageHandler output) throws IOException {
        output.handleIgnoredMessage();
    }

    private void unpackRecordMessage(ResponseMessageHandler output) throws IOException {
        Value[] fields = this.unpacker.unpackArray();
        output.handleRecordMessage(fields);
    }
}

