/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v3;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.BookmarksHolder;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.InternalStatementResultCursor;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.handlers.BeginTxResponseHandler;
import org.neo4j.driver.internal.handlers.CommitTxResponseHandler;
import org.neo4j.driver.internal.handlers.HelloResponseHandler;
import org.neo4j.driver.internal.handlers.NoOpResponseHandler;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RollbackTxResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.SessionPullAllResponseHandler;
import org.neo4j.driver.internal.handlers.TransactionPullAllResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.BeginMessage;
import org.neo4j.driver.internal.messaging.request.CommitMessage;
import org.neo4j.driver.internal.messaging.request.GoodbyeMessage;
import org.neo4j.driver.internal.messaging.request.HelloMessage;
import org.neo4j.driver.internal.messaging.request.PullAllMessage;
import org.neo4j.driver.internal.messaging.request.RollbackMessage;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.messaging.v3.MessageFormatV3;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.TransactionConfig;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public class BoltProtocolV3
implements BoltProtocol {
    public static final int VERSION = 3;
    public static final BoltProtocol INSTANCE = new BoltProtocolV3();
    public static final MetadataExtractor METADATA_EXTRACTOR = new MetadataExtractor("t_first", "t_last");

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV3();
    }

    @Override
    public void initializeChannel(String userAgent, Map<String, Value> authToken, ChannelPromise channelInitializedPromise) {
        Channel channel = channelInitializedPromise.channel();
        HelloMessage message = new HelloMessage(userAgent, authToken);
        HelloResponseHandler handler = new HelloResponseHandler(channelInitializedPromise);
        ChannelAttributes.messageDispatcher(channel).enqueue(handler);
        channel.writeAndFlush(message, channel.voidPromise());
    }

    @Override
    public void prepareToCloseChannel(Channel channel) {
        GoodbyeMessage message = GoodbyeMessage.GOODBYE;
        ChannelAttributes.messageDispatcher(channel).enqueue(NoOpResponseHandler.INSTANCE);
        channel.writeAndFlush(message, channel.voidPromise());
    }

    @Override
    public CompletionStage<Void> beginTransaction(Connection connection, Bookmarks bookmarks, TransactionConfig config) {
        BeginMessage beginMessage = new BeginMessage(bookmarks, config);
        if (bookmarks.isEmpty()) {
            connection.write(beginMessage, NoOpResponseHandler.INSTANCE);
            return Futures.completedWithNull();
        }
        CompletableFuture<Void> beginTxFuture = new CompletableFuture<Void>();
        connection.writeAndFlush(beginMessage, new BeginTxResponseHandler(beginTxFuture));
        return beginTxFuture;
    }

    @Override
    public CompletionStage<Bookmarks> commitTransaction(Connection connection) {
        CompletableFuture<Bookmarks> commitFuture = new CompletableFuture<Bookmarks>();
        connection.writeAndFlush(CommitMessage.COMMIT, new CommitTxResponseHandler(commitFuture));
        return commitFuture;
    }

    @Override
    public CompletionStage<Void> rollbackTransaction(Connection connection) {
        CompletableFuture<Void> rollbackFuture = new CompletableFuture<Void>();
        connection.writeAndFlush(RollbackMessage.ROLLBACK, new RollbackTxResponseHandler(rollbackFuture));
        return rollbackFuture;
    }

    @Override
    public CompletionStage<InternalStatementResultCursor> runInAutoCommitTransaction(Connection connection, Statement statement2, BookmarksHolder bookmarksHolder, TransactionConfig config, boolean waitForRunResponse) {
        return BoltProtocolV3.runStatement(connection, statement2, bookmarksHolder, null, config, waitForRunResponse);
    }

    @Override
    public CompletionStage<InternalStatementResultCursor> runInExplicitTransaction(Connection connection, Statement statement2, ExplicitTransaction tx, boolean waitForRunResponse) {
        return BoltProtocolV3.runStatement(connection, statement2, BookmarksHolder.NO_OP, tx, TransactionConfig.empty(), waitForRunResponse);
    }

    private static CompletionStage<InternalStatementResultCursor> runStatement(Connection connection, Statement statement2, BookmarksHolder bookmarksHolder, ExplicitTransaction tx, TransactionConfig config, boolean waitForRunResponse) {
        String query = statement2.text();
        Map<String, Value> params2 = statement2.parameters().asMap(Values.ofValue());
        CompletableFuture<Void> runCompletedFuture = new CompletableFuture<Void>();
        RunWithMetadataMessage runMessage = new RunWithMetadataMessage(query, params2, bookmarksHolder.getBookmarks(), config);
        RunResponseHandler runHandler = new RunResponseHandler(runCompletedFuture, METADATA_EXTRACTOR);
        PullAllResponseHandler pullAllHandler = BoltProtocolV3.newPullAllHandler(statement2, runHandler, connection, bookmarksHolder, tx);
        connection.writeAndFlush(runMessage, runHandler, PullAllMessage.PULL_ALL, pullAllHandler);
        if (waitForRunResponse) {
            return runCompletedFuture.thenApply(ignore -> new InternalStatementResultCursor(runHandler, pullAllHandler));
        }
        return CompletableFuture.completedFuture(new InternalStatementResultCursor(runHandler, pullAllHandler));
    }

    private static PullAllResponseHandler newPullAllHandler(Statement statement2, RunResponseHandler runHandler, Connection connection, BookmarksHolder bookmarksHolder, ExplicitTransaction tx) {
        if (tx != null) {
            return new TransactionPullAllResponseHandler(statement2, runHandler, connection, tx, METADATA_EXTRACTOR);
        }
        return new SessionPullAllResponseHandler(statement2, runHandler, connection, bookmarksHolder, METADATA_EXTRACTOR);
    }
}

