/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractPooledDerivedByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.PooledDuplicatedByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.util.ByteProcessor;
import org.neo4j.driver.internal.shaded.io.netty.util.Recycler;

final class PooledSlicedByteBuf
extends AbstractPooledDerivedByteBuf {
    private static final Recycler<PooledSlicedByteBuf> RECYCLER = new Recycler<PooledSlicedByteBuf>(){

        @Override
        protected PooledSlicedByteBuf newObject(Recycler.Handle<PooledSlicedByteBuf> handle) {
            return new PooledSlicedByteBuf(handle);
        }
    };
    int adjustment;

    static PooledSlicedByteBuf newInstance(AbstractByteBuf unwrapped, ByteBuf wrapped, int index, int length2) {
        AbstractUnpooledSlicedByteBuf.checkSliceOutOfBounds(index, length2, unwrapped);
        return PooledSlicedByteBuf.newInstance0(unwrapped, wrapped, index, length2);
    }

    private static PooledSlicedByteBuf newInstance0(AbstractByteBuf unwrapped, ByteBuf wrapped, int adjustment, int length2) {
        PooledSlicedByteBuf slice2 = RECYCLER.get();
        slice2.init(unwrapped, wrapped, 0, length2, length2);
        slice2.discardMarks();
        slice2.adjustment = adjustment;
        return slice2;
    }

    private PooledSlicedByteBuf(Recycler.Handle<PooledSlicedByteBuf> handle) {
        super(handle);
    }

    @Override
    public int capacity() {
        return this.maxCapacity();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public int arrayOffset() {
        return this.idx(this.unwrap().arrayOffset());
    }

    @Override
    public long memoryAddress() {
        return this.unwrap().memoryAddress() + (long)this.adjustment;
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length2) {
        this.checkIndex0(index, length2);
        return this.unwrap().nioBuffer(this.idx(index), length2);
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length2) {
        this.checkIndex0(index, length2);
        return this.unwrap().nioBuffers(this.idx(index), length2);
    }

    @Override
    public ByteBuf copy(int index, int length2) {
        this.checkIndex0(index, length2);
        return this.unwrap().copy(this.idx(index), length2);
    }

    @Override
    public ByteBuf slice(int index, int length2) {
        this.checkIndex0(index, length2);
        return super.slice(this.idx(index), length2);
    }

    @Override
    public ByteBuf retainedSlice(int index, int length2) {
        this.checkIndex0(index, length2);
        return PooledSlicedByteBuf.newInstance0(this.unwrap(), this, this.idx(index), length2);
    }

    @Override
    public ByteBuf duplicate() {
        return this.duplicate0().setIndex(this.idx(this.readerIndex()), this.idx(this.writerIndex()));
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this.unwrap(), this, this.idx(this.readerIndex()), this.idx(this.writerIndex()));
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex0(index, 1);
        return this.unwrap().getByte(this.idx(index));
    }

    @Override
    protected byte _getByte(int index) {
        return this.unwrap()._getByte(this.idx(index));
    }

    @Override
    public short getShort(int index) {
        this.checkIndex0(index, 2);
        return this.unwrap().getShort(this.idx(index));
    }

    @Override
    protected short _getShort(int index) {
        return this.unwrap()._getShort(this.idx(index));
    }

    @Override
    public short getShortLE(int index) {
        this.checkIndex0(index, 2);
        return this.unwrap().getShortLE(this.idx(index));
    }

    @Override
    protected short _getShortLE(int index) {
        return this.unwrap()._getShortLE(this.idx(index));
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.checkIndex0(index, 3);
        return this.unwrap().getUnsignedMedium(this.idx(index));
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        return this.unwrap()._getUnsignedMedium(this.idx(index));
    }

    @Override
    public int getUnsignedMediumLE(int index) {
        this.checkIndex0(index, 3);
        return this.unwrap().getUnsignedMediumLE(this.idx(index));
    }

    @Override
    protected int _getUnsignedMediumLE(int index) {
        return this.unwrap()._getUnsignedMediumLE(this.idx(index));
    }

    @Override
    public int getInt(int index) {
        this.checkIndex0(index, 4);
        return this.unwrap().getInt(this.idx(index));
    }

    @Override
    protected int _getInt(int index) {
        return this.unwrap()._getInt(this.idx(index));
    }

    @Override
    public int getIntLE(int index) {
        this.checkIndex0(index, 4);
        return this.unwrap().getIntLE(this.idx(index));
    }

    @Override
    protected int _getIntLE(int index) {
        return this.unwrap()._getIntLE(this.idx(index));
    }

    @Override
    public long getLong(int index) {
        this.checkIndex0(index, 8);
        return this.unwrap().getLong(this.idx(index));
    }

    @Override
    protected long _getLong(int index) {
        return this.unwrap()._getLong(this.idx(index));
    }

    @Override
    public long getLongLE(int index) {
        this.checkIndex0(index, 8);
        return this.unwrap().getLongLE(this.idx(index));
    }

    @Override
    protected long _getLongLE(int index) {
        return this.unwrap()._getLongLE(this.idx(index));
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length2) {
        this.checkIndex0(index, length2);
        this.unwrap().getBytes(this.idx(index), dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length2) {
        this.checkIndex0(index, length2);
        this.unwrap().getBytes(this.idx(index), dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.checkIndex0(index, dst.remaining());
        this.unwrap().getBytes(this.idx(index), dst);
        return this;
    }

    @Override
    public ByteBuf setByte(int index, int value2) {
        this.checkIndex0(index, 1);
        this.unwrap().setByte(this.idx(index), value2);
        return this;
    }

    @Override
    protected void _setByte(int index, int value2) {
        this.unwrap()._setByte(this.idx(index), value2);
    }

    @Override
    public ByteBuf setShort(int index, int value2) {
        this.checkIndex0(index, 2);
        this.unwrap().setShort(this.idx(index), value2);
        return this;
    }

    @Override
    protected void _setShort(int index, int value2) {
        this.unwrap()._setShort(this.idx(index), value2);
    }

    @Override
    public ByteBuf setShortLE(int index, int value2) {
        this.checkIndex0(index, 2);
        this.unwrap().setShortLE(this.idx(index), value2);
        return this;
    }

    @Override
    protected void _setShortLE(int index, int value2) {
        this.unwrap()._setShortLE(this.idx(index), value2);
    }

    @Override
    public ByteBuf setMedium(int index, int value2) {
        this.checkIndex0(index, 3);
        this.unwrap().setMedium(this.idx(index), value2);
        return this;
    }

    @Override
    protected void _setMedium(int index, int value2) {
        this.unwrap()._setMedium(this.idx(index), value2);
    }

    @Override
    public ByteBuf setMediumLE(int index, int value2) {
        this.checkIndex0(index, 3);
        this.unwrap().setMediumLE(this.idx(index), value2);
        return this;
    }

    @Override
    protected void _setMediumLE(int index, int value2) {
        this.unwrap()._setMediumLE(this.idx(index), value2);
    }

    @Override
    public ByteBuf setInt(int index, int value2) {
        this.checkIndex0(index, 4);
        this.unwrap().setInt(this.idx(index), value2);
        return this;
    }

    @Override
    protected void _setInt(int index, int value2) {
        this.unwrap()._setInt(this.idx(index), value2);
    }

    @Override
    public ByteBuf setIntLE(int index, int value2) {
        this.checkIndex0(index, 4);
        this.unwrap().setIntLE(this.idx(index), value2);
        return this;
    }

    @Override
    protected void _setIntLE(int index, int value2) {
        this.unwrap()._setIntLE(this.idx(index), value2);
    }

    @Override
    public ByteBuf setLong(int index, long value2) {
        this.checkIndex0(index, 8);
        this.unwrap().setLong(this.idx(index), value2);
        return this;
    }

    @Override
    protected void _setLong(int index, long value2) {
        this.unwrap()._setLong(this.idx(index), value2);
    }

    @Override
    public ByteBuf setLongLE(int index, long value2) {
        this.checkIndex0(index, 8);
        this.unwrap().setLongLE(this.idx(index), value2);
        return this;
    }

    @Override
    protected void _setLongLE(int index, long value2) {
        this.unwrap().setLongLE(this.idx(index), value2);
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length2) {
        this.checkIndex0(index, length2);
        this.unwrap().setBytes(this.idx(index), src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length2) {
        this.checkIndex0(index, length2);
        this.unwrap().setBytes(this.idx(index), src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.checkIndex0(index, src.remaining());
        this.unwrap().setBytes(this.idx(index), src);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length2) throws IOException {
        this.checkIndex0(index, length2);
        this.unwrap().getBytes(this.idx(index), out, length2);
        return this;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length2) throws IOException {
        this.checkIndex0(index, length2);
        return this.unwrap().getBytes(this.idx(index), out, length2);
    }

    @Override
    public int getBytes(int index, FileChannel out, long position2, int length2) throws IOException {
        this.checkIndex0(index, length2);
        return this.unwrap().getBytes(this.idx(index), out, position2, length2);
    }

    @Override
    public int setBytes(int index, InputStream in2, int length2) throws IOException {
        this.checkIndex0(index, length2);
        return this.unwrap().setBytes(this.idx(index), in2, length2);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in2, int length2) throws IOException {
        this.checkIndex0(index, length2);
        return this.unwrap().setBytes(this.idx(index), in2, length2);
    }

    @Override
    public int setBytes(int index, FileChannel in2, long position2, int length2) throws IOException {
        this.checkIndex0(index, length2);
        return this.unwrap().setBytes(this.idx(index), in2, position2, length2);
    }

    @Override
    public int forEachByte(int index, int length2, ByteProcessor processor) {
        this.checkIndex0(index, length2);
        int ret = this.unwrap().forEachByte(this.idx(index), length2, processor);
        if (ret < this.adjustment) {
            return -1;
        }
        return ret - this.adjustment;
    }

    @Override
    public int forEachByteDesc(int index, int length2, ByteProcessor processor) {
        this.checkIndex0(index, length2);
        int ret = this.unwrap().forEachByteDesc(this.idx(index), length2, processor);
        if (ret < this.adjustment) {
            return -1;
        }
        return ret - this.adjustment;
    }

    private int idx(int index) {
        return index + this.adjustment;
    }
}

