/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.FileRegion;
import org.neo4j.driver.internal.shaded.io.netty.util.AbstractReferenceCounted;
import org.neo4j.driver.internal.shaded.io.netty.util.IllegalReferenceCountException;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.logging.InternalLogger;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class DefaultFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultFileRegion.class);
    private final File f;
    private final long position;
    private final long count;
    private long transferred;
    private FileChannel file;

    public DefaultFileRegion(FileChannel file, long position2, long count2) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (position2 < 0L) {
            throw new IllegalArgumentException("position must be >= 0 but was " + position2);
        }
        if (count2 < 0L) {
            throw new IllegalArgumentException("count must be >= 0 but was " + count2);
        }
        this.file = file;
        this.position = position2;
        this.count = count2;
        this.f = null;
    }

    public DefaultFileRegion(File f, long position2, long count2) {
        if (f == null) {
            throw new NullPointerException("f");
        }
        if (position2 < 0L) {
            throw new IllegalArgumentException("position must be >= 0 but was " + position2);
        }
        if (count2 < 0L) {
            throw new IllegalArgumentException("count must be >= 0 but was " + count2);
        }
        this.position = position2;
        this.count = count2;
        this.f = f;
    }

    public boolean isOpen() {
        return this.file != null;
    }

    public void open() throws IOException {
        if (!this.isOpen() && this.refCnt() > 0) {
            this.file = new RandomAccessFile(this.f, "r").getChannel();
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    @Deprecated
    public long transfered() {
        return this.transferred;
    }

    @Override
    public long transferred() {
        return this.transferred;
    }

    @Override
    public long transferTo(WritableByteChannel target, long position2) throws IOException {
        long count2 = this.count - position2;
        if (count2 < 0L || position2 < 0L) {
            throw new IllegalArgumentException("position out of range: " + position2 + " (expected: 0 - " + (this.count - 1L) + ')');
        }
        if (count2 == 0L) {
            return 0L;
        }
        if (this.refCnt() == 0) {
            throw new IllegalReferenceCountException(0);
        }
        this.open();
        long written = this.file.transferTo(this.position + position2, count2, target);
        if (written > 0L) {
            this.transferred += written;
        }
        return written;
    }

    @Override
    protected void deallocate() {
        block3: {
            FileChannel file = this.file;
            if (file == null) {
                return;
            }
            this.file = null;
            try {
                file.close();
            }
            catch (IOException e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("Failed to close a file.", e);
            }
        }
    }

    @Override
    public FileRegion retain() {
        super.retain();
        return this;
    }

    @Override
    public FileRegion retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public FileRegion touch() {
        return this;
    }

    @Override
    public FileRegion touch(Object hint) {
        return this;
    }
}

