/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.protobuf;

import java.util.List;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.CorruptedFrameException;

public class ProtobufVarint32FrameDecoder
extends ByteToMessageDecoder {
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in2, List<Object> out) throws Exception {
        in2.markReaderIndex();
        int preIndex = in2.readerIndex();
        int length2 = ProtobufVarint32FrameDecoder.readRawVarint32(in2);
        if (preIndex == in2.readerIndex()) {
            return;
        }
        if (length2 < 0) {
            throw new CorruptedFrameException("negative length: " + length2);
        }
        if (in2.readableBytes() < length2) {
            in2.resetReaderIndex();
        } else {
            out.add(in2.readRetainedSlice(length2));
        }
    }

    private static int readRawVarint32(ByteBuf buffer) {
        if (!buffer.isReadable()) {
            return 0;
        }
        buffer.markReaderIndex();
        byte tmp = buffer.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result2 = tmp & 0x7F;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            result2 |= tmp << 7;
        } else {
            result2 |= (tmp & 0x7F) << 7;
            if (!buffer.isReadable()) {
                buffer.resetReaderIndex();
                return 0;
            }
            tmp = buffer.readByte();
            if (tmp >= 0) {
                result2 |= tmp << 14;
            } else {
                result2 |= (tmp & 0x7F) << 14;
                if (!buffer.isReadable()) {
                    buffer.resetReaderIndex();
                    return 0;
                }
                tmp = buffer.readByte();
                if (tmp >= 0) {
                    result2 |= tmp << 21;
                } else {
                    result2 |= (tmp & 0x7F) << 21;
                    if (!buffer.isReadable()) {
                        buffer.resetReaderIndex();
                        return 0;
                    }
                    tmp = buffer.readByte();
                    result2 |= tmp << 28;
                    if (tmp < 0) {
                        throw new CorruptedFrameException("malformed varint.");
                    }
                }
            }
        }
        return result2;
    }
}

