/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.summary.InternalPlan;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.util.Function;

public class InternalProfiledPlan
extends InternalPlan<ProfiledPlan>
implements ProfiledPlan {
    private final long dbHits;
    private final long records;
    public static final InternalPlan.PlanCreator<ProfiledPlan> PROFILED_PLAN = new InternalPlan.PlanCreator<ProfiledPlan>(){

        @Override
        public ProfiledPlan create(String operatorType, Map<String, Value> arguments2, List<String> identifiers, List<ProfiledPlan> children2, Value originalPlanValue) {
            return new InternalProfiledPlan(operatorType, arguments2, identifiers, children2, originalPlanValue.get("dbHits").asLong(), originalPlanValue.get("rows").asLong());
        }
    };
    public static final Function<Value, ProfiledPlan> PROFILED_PLAN_FROM_VALUE = new InternalPlan.Converter<ProfiledPlan>(PROFILED_PLAN);

    protected InternalProfiledPlan(String operatorType, Map<String, Value> arguments2, List<String> identifiers, List<ProfiledPlan> children2, long dbHits, long records) {
        super(operatorType, arguments2, identifiers, children2);
        this.dbHits = dbHits;
        this.records = records;
    }

    @Override
    public long dbHits() {
        return this.dbHits;
    }

    @Override
    public long records() {
        return this.records;
    }
}

