/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.internal.summary.InternalSummaryCounters;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.summary.Notification;
import org.neo4j.driver.v1.summary.Plan;
import org.neo4j.driver.v1.summary.ProfiledPlan;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.summary.ServerInfo;
import org.neo4j.driver.v1.summary.StatementType;
import org.neo4j.driver.v1.summary.SummaryCounters;

public class InternalResultSummary
implements ResultSummary {
    private final Statement statement;
    private final ServerInfo serverInfo;
    private final StatementType statementType;
    private final SummaryCounters counters;
    private final Plan plan;
    private final ProfiledPlan profile;
    private final List<Notification> notifications;
    private final long resultAvailableAfter;
    private final long resultConsumedAfter;

    public InternalResultSummary(Statement statement2, ServerInfo serverInfo, StatementType statementType, SummaryCounters counters, Plan plan, ProfiledPlan profile, List<Notification> notifications, long resultAvailableAfter, long resultConsumedAfter) {
        this.statement = statement2;
        this.serverInfo = serverInfo;
        this.statementType = statementType;
        this.counters = counters;
        this.plan = InternalResultSummary.resolvePlan(plan, profile);
        this.profile = profile;
        this.notifications = notifications;
        this.resultAvailableAfter = resultAvailableAfter;
        this.resultConsumedAfter = resultConsumedAfter;
    }

    @Override
    public Statement statement() {
        return this.statement;
    }

    @Override
    public SummaryCounters counters() {
        return this.counters == null ? InternalSummaryCounters.EMPTY_STATS : this.counters;
    }

    @Override
    public StatementType statementType() {
        return this.statementType;
    }

    @Override
    public boolean hasPlan() {
        return this.plan != null;
    }

    @Override
    public boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    public Plan plan() {
        return this.plan;
    }

    @Override
    public ProfiledPlan profile() {
        return this.profile;
    }

    @Override
    public List<Notification> notifications() {
        return this.notifications == null ? Collections.emptyList() : this.notifications;
    }

    @Override
    public long resultAvailableAfter(TimeUnit unit) {
        return this.resultAvailableAfter == -1L ? this.resultAvailableAfter : unit.convert(this.resultAvailableAfter, TimeUnit.MILLISECONDS);
    }

    @Override
    public long resultConsumedAfter(TimeUnit unit) {
        return this.resultConsumedAfter == -1L ? this.resultConsumedAfter : unit.convert(this.resultConsumedAfter, TimeUnit.MILLISECONDS);
    }

    @Override
    public ServerInfo server() {
        return this.serverInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalResultSummary that = (InternalResultSummary)o;
        return this.resultAvailableAfter == that.resultAvailableAfter && this.resultConsumedAfter == that.resultConsumedAfter && Objects.equals(this.statement, that.statement) && Objects.equals(this.serverInfo, that.serverInfo) && this.statementType == that.statementType && Objects.equals(this.counters, that.counters) && Objects.equals(this.plan, that.plan) && Objects.equals(this.profile, that.profile) && Objects.equals(this.notifications, that.notifications);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.statement, this.serverInfo, this.statementType, this.counters, this.plan, this.profile, this.notifications, this.resultAvailableAfter, this.resultConsumedAfter});
    }

    public String toString() {
        return "InternalResultSummary{statement=" + this.statement + ", serverInfo=" + this.serverInfo + ", statementType=" + (Object)((Object)this.statementType) + ", counters=" + this.counters + ", plan=" + this.plan + ", profile=" + this.profile + ", notifications=" + this.notifications + ", resultAvailableAfter=" + this.resultAvailableAfter + ", resultConsumedAfter=" + this.resultConsumedAfter + '}';
    }

    private static Plan resolvePlan(Plan plan, ProfiledPlan profiledPlan) {
        return plan == null ? profiledPlan : plan;
    }
}

