/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.Collections;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.DijkstraSelectorFactory;
import org.neo4j.graphalgo.impl.util.PathInterest;
import org.neo4j.graphalgo.impl.util.PathInterestFactory;
import org.neo4j.graphalgo.impl.util.WeightedPathIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;
import org.neo4j.kernel.impl.util.NoneStrictMath;

public class Dijkstra
implements PathFinder<WeightedPath> {
    private final PathExpander expander;
    private final InitialBranchState stateFactory;
    private final CostEvaluator<Double> costEvaluator;
    private Traverser lastTraverser;
    private final double epsilon;
    private final PathInterest<Double> interest;
    private final boolean stateInUse;

    @Deprecated
    public Dijkstra(PathExpander expander, InitialBranchState stateFactory, CostEvaluator<Double> costEvaluator) {
        this(expander, stateFactory, costEvaluator, true);
    }

    @Deprecated
    public Dijkstra(PathExpander expander, InitialBranchState stateFactory, CostEvaluator<Double> costEvaluator, boolean stopAfterLowestCost) {
        this.expander = expander;
        this.costEvaluator = costEvaluator;
        this.stateFactory = stateFactory;
        this.interest = stopAfterLowestCost ? PathInterestFactory.allShortest(NoneStrictMath.EPSILON) : PathInterestFactory.all(NoneStrictMath.EPSILON);
        this.epsilon = NoneStrictMath.EPSILON;
        this.stateInUse = true;
    }

    public Dijkstra(PathExpander expander, CostEvaluator<Double> costEvaluator) {
        this(expander, costEvaluator, PathInterestFactory.allShortest(NoneStrictMath.EPSILON));
    }

    @Deprecated
    public Dijkstra(PathExpander expander, CostEvaluator<Double> costEvaluator, boolean stopAfterLowestCost) {
        this(expander, costEvaluator, NoneStrictMath.EPSILON, stopAfterLowestCost ? PathInterestFactory.allShortest(NoneStrictMath.EPSILON) : PathInterestFactory.all(NoneStrictMath.EPSILON));
    }

    public Dijkstra(PathExpander expander, CostEvaluator<Double> costEvaluator, PathInterest<Double> interest) {
        this(expander, costEvaluator, NoneStrictMath.EPSILON, interest);
    }

    public Dijkstra(PathExpander expander, CostEvaluator<Double> costEvaluator, double epsilon, PathInterest<Double> interest) {
        this.expander = expander;
        this.costEvaluator = costEvaluator;
        this.epsilon = epsilon;
        this.interest = interest;
        this.stateFactory = InitialBranchState.DOUBLE_ZERO;
        this.stateInUse = false;
    }

    @Override
    public Iterable<WeightedPath> findAllPaths(Node start, Node end) {
        Traverser traverser = this.traverser(start, end, this.interest);
        return () -> new WeightedPathIterator((ResourceIterator<Path>)traverser.iterator(), this.costEvaluator, this.epsilon, this.interest);
    }

    private Traverser traverser(Node start, Node end, PathInterest<Double> interest) {
        DijkstraEvaluator dijkstraEvaluator;
        PathExpander dijkstraExpander;
        if (this.stateInUse) {
            dijkstraExpander = this.expander;
            dijkstraEvaluator = Evaluators.includeWhereEndNodeIs(end);
        } else {
            MutableDouble shortestSoFar = new MutableDouble(Double.MAX_VALUE);
            dijkstraExpander = new DijkstraPathExpander(this.expander, shortestSoFar, this.epsilon, interest.stopAfterLowestCost());
            dijkstraEvaluator = new DijkstraEvaluator(shortestSoFar, end, this.costEvaluator);
        }
        this.lastTraverser = new MonoDirectionalTraversalDescription().uniqueness(Uniqueness.NODE_PATH).expand(dijkstraExpander, this.stateFactory).order(new DijkstraSelectorFactory(interest, this.costEvaluator)).evaluator(dijkstraEvaluator).traverse(start);
        return this.lastTraverser;
    }

    @Override
    public WeightedPath findSinglePath(Node start, Node end) {
        return Iterators.firstOrNull(new WeightedPathIterator((ResourceIterator<Path>)this.traverser(start, end, PathInterestFactory.single(this.epsilon)).iterator(), this.costEvaluator, this.epsilon, this.interest));
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastTraverser.metadata();
    }

    private static class DijkstraEvaluator
    extends PathEvaluator.Adapter<Double> {
        private final MutableDouble shortestSoFar;
        private final Node endNode;
        private final CostEvaluator<Double> costEvaluator;

        DijkstraEvaluator(MutableDouble shortestSoFar, Node endNode, CostEvaluator<Double> costEvaluator) {
            this.shortestSoFar = shortestSoFar;
            this.endNode = endNode;
            this.costEvaluator = costEvaluator;
        }

        @Override
        public Evaluation evaluate(Path path, BranchState<Double> state) {
            double nextState = state.getState();
            if (path.length() > 0) {
                state.setState(nextState += this.costEvaluator.getCost(path.lastRelationship(), Direction.OUTGOING).doubleValue());
            }
            if (path.endNode().equals(this.endNode)) {
                this.shortestSoFar.setValue(Math.min(this.shortestSoFar.doubleValue(), nextState));
                return Evaluation.INCLUDE_AND_PRUNE;
            }
            return Evaluation.EXCLUDE_AND_CONTINUE;
        }
    }

    private static class DijkstraPathExpander
    implements PathExpander<Double> {
        protected final PathExpander source;
        protected MutableDouble shortestSoFar;
        private final double epsilon;
        protected final boolean stopAfterLowestCost;

        DijkstraPathExpander(PathExpander source, MutableDouble shortestSoFar, double epsilon, boolean stopAfterLowestCost) {
            this.source = source;
            this.shortestSoFar = shortestSoFar;
            this.epsilon = epsilon;
            this.stopAfterLowestCost = stopAfterLowestCost;
        }

        @Override
        public Iterable<Relationship> expand(Path path, BranchState<Double> state) {
            if (NoneStrictMath.compare(state.getState(), this.shortestSoFar.doubleValue(), this.epsilon) > 0 && this.stopAfterLowestCost) {
                return Collections.emptyList();
            }
            return this.source.expand(path, state);
        }

        @Override
        public PathExpander<Double> reverse() {
            return new DijkstraPathExpander(this.source.reverse(), this.shortestSoFar, this.epsilon, this.stopAfterLowestCost);
        }
    }
}

