/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.BestFirstSelectorFactory;
import org.neo4j.graphalgo.impl.util.PathInterest;
import org.neo4j.graphalgo.impl.util.PathInterestFactory;
import org.neo4j.graphalgo.impl.util.WeightedPathIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;

public class TraversalAStar
implements PathFinder<WeightedPath> {
    private final CostEvaluator<Double> costEvaluator;
    private final PathExpander expander;
    private final InitialBranchState initialState;
    private Traverser lastTraverser;
    private final EstimateEvaluator<Double> estimateEvaluator;
    private boolean stopAfterLowestWeight;

    public <T> TraversalAStar(PathExpander<T> expander, CostEvaluator<Double> costEvaluator, EstimateEvaluator<Double> estimateEvaluator) {
        this(expander, InitialBranchState.NO_STATE, costEvaluator, estimateEvaluator, true);
    }

    public <T> TraversalAStar(PathExpander<T> expander, InitialBranchState<T> initialState, CostEvaluator<Double> costEvaluator, EstimateEvaluator<Double> estimateEvaluator) {
        this(expander, initialState, costEvaluator, estimateEvaluator, true);
    }

    public <T> TraversalAStar(PathExpander<T> expander, CostEvaluator<Double> costEvaluator, EstimateEvaluator<Double> estimateEvaluator, boolean stopAfterLowestWeight) {
        this(expander, InitialBranchState.NO_STATE, costEvaluator, estimateEvaluator, stopAfterLowestWeight);
    }

    public <T> TraversalAStar(PathExpander<T> expander, InitialBranchState<T> initialState, CostEvaluator<Double> costEvaluator, EstimateEvaluator<Double> estimateEvaluator, boolean stopAfterLowestWeight) {
        this.costEvaluator = costEvaluator;
        this.estimateEvaluator = estimateEvaluator;
        this.stopAfterLowestWeight = stopAfterLowestWeight;
        this.expander = expander;
        this.initialState = initialState;
    }

    @Override
    public Iterable<WeightedPath> findAllPaths(Node start, Node end) {
        return Iterables.asIterable(this.findSinglePath(start, end));
    }

    @Override
    public WeightedPath findSinglePath(Node start, Node end) {
        return Iterables.firstOrNull(this.findPaths(start, end, false));
    }

    private ResourceIterable<WeightedPath> findPaths(Node start, Node end, boolean multiplePaths) {
        PathInterest<? extends Comparable> interest = multiplePaths ? (this.stopAfterLowestWeight ? PathInterestFactory.allShortest() : PathInterestFactory.all()) : PathInterestFactory.single();
        GraphDatabaseService db = start.getGraphDatabase();
        TraversalDescription traversalDescription = db.traversalDescription().uniqueness(Uniqueness.NONE).expand(this.expander, this.initialState);
        this.lastTraverser = traversalDescription.order(new SelectorFactory(end, interest)).evaluator(Evaluators.includeWhereEndNodeIs(end)).traverse(start);
        return Iterators.asResourceIterable(new WeightedPathIterator((ResourceIterator<Path>)this.lastTraverser.iterator(), this.costEvaluator, this.stopAfterLowestWeight));
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastTraverser.metadata();
    }

    private class SelectorFactory
    extends BestFirstSelectorFactory<PositionData, Double> {
        private final Node end;

        SelectorFactory(Node end, PathInterest interest) {
            super(interest);
            this.end = end;
        }

        @Override
        protected PositionData addPriority(TraversalBranch source, PositionData currentAggregatedValue, Double value2) {
            return new PositionData(currentAggregatedValue.wayLengthG + value2, (Double)TraversalAStar.this.estimateEvaluator.getCost(source.endNode(), this.end));
        }

        @Override
        protected Double calculateValue(TraversalBranch next2) {
            return next2.length() == 0 ? Double.valueOf(0.0) : (Double)TraversalAStar.this.costEvaluator.getCost(next2.lastRelationship(), Direction.OUTGOING);
        }

        @Override
        protected PositionData getStartData() {
            return new PositionData(0.0, 0.0);
        }
    }

    private static class PositionData
    implements Comparable<PositionData> {
        private final double wayLengthG;
        private final double estimateH;

        PositionData(double wayLengthG, double estimateH) {
            this.wayLengthG = wayLengthG;
            this.estimateH = estimateH;
        }

        Double f() {
            return this.estimateH + this.wayLengthG;
        }

        @Override
        public int compareTo(PositionData o) {
            return this.f().compareTo(o.f());
        }

        public String toString() {
            return "g:" + this.wayLengthG + ", h:" + this.estimateH;
        }
    }
}

