/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import org.neo4j.graphalgo.impl.path.TraversalPathFinder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.SideSelectorPolicies;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;

public class TraversalShortestPath
extends TraversalPathFinder {
    private final PathExpander expander;
    private final int maxDepth;
    private final Integer maxResultCount;

    public TraversalShortestPath(PathExpander expander, int maxDepth2) {
        this.expander = expander;
        this.maxDepth = maxDepth2;
        this.maxResultCount = null;
    }

    public TraversalShortestPath(PathExpander expander, int maxDepth2, int maxResultCount) {
        this.expander = expander;
        this.maxDepth = maxDepth2;
        this.maxResultCount = maxResultCount;
    }

    @Override
    protected Traverser instantiateTraverser(Node start, Node end) {
        GraphDatabaseService db = start.getGraphDatabase();
        TraversalDescription sideBase = db.traversalDescription().breadthFirst().uniqueness(Uniqueness.NODE_PATH);
        return db.bidirectionalTraversalDescription().mirroredSides(sideBase.expand(this.expander)).sideSelector(SideSelectorPolicies.LEVEL_STOP_DESCENT_ON_RESULT, this.maxDepth).collisionEvaluator(Evaluators.toDepth(this.maxDepth)).traverse(start, end);
    }

    @Override
    protected Integer maxResultCount() {
        return this.maxResultCount;
    }
}

