/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;

public class FibonacciHeap<KeyType> {
    Comparator<KeyType> keyComparator;
    FibonacciHeapNode minimum;
    int nrNodes;

    public FibonacciHeap(Comparator<KeyType> keyComparator) {
        this.keyComparator = keyComparator;
    }

    public boolean isEmpty() {
        return this.minimum == null;
    }

    public int size() {
        return this.nrNodes;
    }

    public FibonacciHeapNode getMinimum() {
        return this.minimum;
    }

    protected void insertInRootList(FibonacciHeapNode fNode) {
        fNode.parent = null;
        fNode.marked = false;
        if (this.minimum == null) {
            this.minimum.right = this.minimum = fNode;
            this.minimum.left = this.minimum;
        } else {
            fNode.left = this.minimum.left;
            fNode.right = this.minimum;
            fNode.left.right = fNode;
            fNode.right.left = fNode;
            if (this.keyComparator.compare(fNode.key, this.minimum.key) < 0) {
                this.minimum = fNode;
            }
        }
    }

    public FibonacciHeapNode insert(KeyType key) {
        FibonacciHeapNode node = new FibonacciHeapNode(key);
        this.insertInRootList(node);
        ++this.nrNodes;
        return node;
    }

    public void union(FibonacciHeap<KeyType> other2) {
        this.nrNodes += other2.nrNodes;
        if (other2.minimum == null) {
            return;
        }
        if (this.minimum == null) {
            this.minimum = other2.minimum;
            return;
        }
        FibonacciHeapNode otherLeft = other2.minimum.left;
        other2.minimum.left = this.minimum.left;
        this.minimum.left = otherLeft;
        this.minimum.left.right = this.minimum;
        other2.minimum.left.right = other2.minimum;
        if (this.keyComparator.compare(other2.minimum.key, this.minimum.key) < 0) {
            this.minimum = other2.minimum;
        }
    }

    public KeyType extractMin() {
        if (this.minimum == null) {
            return null;
        }
        FibonacciHeapNode minNode = this.minimum;
        if (minNode.child != null) {
            FibonacciHeapNode child = minNode.child;
            while (minNode.equals(child.parent)) {
                FibonacciHeapNode nextChild = child.right;
                this.insertInRootList(child);
                child = nextChild;
            }
        }
        minNode.left.right = minNode.right;
        minNode.right.left = minNode.left;
        if (minNode.right.equals(minNode)) {
            this.minimum = null;
        } else {
            this.minimum = this.minimum.right;
            this.consolidate();
        }
        --this.nrNodes;
        return minNode.key;
    }

    protected void consolidate() {
        int arraySize = this.nrNodes + 1;
        ArrayList<FibonacciHeapNode> nodes = new ArrayList<FibonacciHeapNode>(arraySize);
        for (int i = 0; i < arraySize; ++i) {
            nodes.add(null);
        }
        LinkedList<FibonacciHeapNode> rootNodes = new LinkedList<FibonacciHeapNode>();
        rootNodes.add(this.minimum);
        FibonacciHeapNode n = this.minimum.right;
        while (!n.equals(this.minimum)) {
            rootNodes.add(n);
            n = n.right;
        }
        for (FibonacciHeapNode node : rootNodes) {
            if (node.parent != null) continue;
            int d = node.degree;
            while (nodes.get(d) != null) {
                FibonacciHeapNode y = (FibonacciHeapNode)nodes.get(d);
                if (this.keyComparator.compare(node.key, y.key) > 0) {
                    FibonacciHeapNode tmp = node;
                    node = y;
                    y = tmp;
                }
                this.link(y, node);
                nodes.set(d, null);
                ++d;
            }
            nodes.set(d, node);
        }
        this.minimum = null;
        for (FibonacciHeapNode node : nodes) {
            if (node == null) continue;
            this.insertInRootList(node);
        }
    }

    protected void link(FibonacciHeapNode y, FibonacciHeapNode x) {
        y.left.right = y.right;
        y.right.left = y.left;
        if (x.child == null) {
            y.right = y;
            y.left = y;
        } else {
            y.left = x.child.left;
            y.right = x.child;
            y.right.left = y;
            y.left.right = y;
        }
        x.child = y;
        y.parent = x;
        ++x.degree;
        y.marked = false;
    }

    public void decreaseKey(FibonacciHeapNode node, KeyType newKey) {
        if (this.keyComparator.compare(newKey, node.key) > 0) {
            throw new RuntimeException("Trying to decrease to a greater key");
        }
        node.key = newKey;
        FibonacciHeapNode parent2 = node.parent;
        if (parent2 != null && this.keyComparator.compare(node.key, parent2.key) < 0) {
            this.cut(node, parent2);
            this.cascadingCut(parent2);
        }
        if (this.keyComparator.compare(node.key, this.minimum.key) < 0) {
            this.minimum = node;
        }
    }

    protected void cut(FibonacciHeapNode x, FibonacciHeapNode y) {
        x.left.right = x.right;
        x.right.left = x.left;
        y.child = x.right.equals(x) ? null : x.right;
        --y.degree;
        this.insertInRootList(x);
    }

    protected void cascadingCut(FibonacciHeapNode y) {
        FibonacciHeapNode parent2 = y.parent;
        if (parent2 != null) {
            if (!parent2.marked) {
                parent2.marked = true;
            } else {
                this.cut(y, parent2);
                this.cascadingCut(parent2);
            }
        }
    }

    public class FibonacciHeapNode {
        FibonacciHeapNode left;
        FibonacciHeapNode right;
        FibonacciHeapNode parent;
        FibonacciHeapNode child;
        boolean marked;
        KeyType key;
        int degree;

        public FibonacciHeapNode(KeyType key) {
            this.key = key;
            this.left = this;
            this.right = this;
        }

        public KeyType getKey() {
            return this.key;
        }
    }
}

