/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.helpers.collection.ArrayIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.ReverseArrayIterator;

public final class PathImpl
implements Path {
    private final Node start;
    private final Relationship[] path;
    private final Node end;

    private static String relToString(Relationship rel) {
        return rel.getStartNode() + "--" + rel.getType() + "-->" + rel.getEndNode();
    }

    private PathImpl(Builder left2, Builder right2) {
        int i;
        Node endNode = null;
        this.path = new Relationship[left2.size + (right2 == null ? 0 : right2.size)];
        if (right2 != null) {
            int total2 = i + right2.size;
            for (i = left2.size; i < total2; ++i) {
                this.path[i] = right2.relationship;
                right2 = right2.previous;
            }
            assert (right2.relationship == null) : "right Path.Builder size error";
            endNode = right2.start;
        }
        for (i = left2.size - 1; i >= 0; --i) {
            this.path[i] = left2.relationship;
            left2 = left2.previous;
        }
        assert (left2.relationship == null) : "left Path.Builder size error";
        this.start = left2.start;
        this.end = endNode;
    }

    public static Path singular(Node start) {
        return new Builder(start).build();
    }

    @Override
    public Node startNode() {
        return this.start;
    }

    @Override
    public Node endNode() {
        if (this.end != null) {
            return this.end;
        }
        Node stepNode = null;
        Iterator<Node> iterator2 = this.nodes().iterator();
        while (iterator2.hasNext()) {
            Node node;
            stepNode = node = iterator2.next();
        }
        return stepNode;
    }

    @Override
    public Relationship lastRelationship() {
        return this.path != null && this.path.length > 0 ? this.path[this.path.length - 1] : null;
    }

    @Override
    public Iterable<Node> nodes() {
        return this.nodeIterator(this.start, this.relationships());
    }

    @Override
    public Iterable<Node> reverseNodes() {
        return this.nodeIterator(this.endNode(), this.reverseRelationships());
    }

    private Iterable<Node> nodeIterator(final Node start, final Iterable<Relationship> relationships) {
        return () -> new Iterator<Node>(){
            Node current;
            int index;
            Iterator relationshipIterator;
            {
                this.current = start;
                this.relationshipIterator = relationships.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.index <= PathImpl.this.path.length;
            }

            @Override
            public Node next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Node next2 = null;
                if (this.index < PathImpl.this.path.length) {
                    if (!this.relationshipIterator.hasNext()) {
                        throw new IllegalStateException(String.format("Number of relationships: %d does not match with path length: %d.", this.index, PathImpl.this.path.length));
                    }
                    next2 = ((Relationship)this.relationshipIterator.next()).getOtherNode(this.current);
                }
                ++this.index;
                try {
                    Node node = this.current;
                    return node;
                }
                finally {
                    this.current = next2;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterable<Relationship> relationships() {
        return () -> new ArrayIterator<Relationship>(this.path);
    }

    @Override
    public Iterable<Relationship> reverseRelationships() {
        return () -> new ReverseArrayIterator<Relationship>(this.path);
    }

    @Override
    public Iterator<PropertyContainer> iterator() {
        return new Iterator<PropertyContainer>(){
            Iterator<? extends PropertyContainer> current;
            Iterator<? extends PropertyContainer> next;
            {
                this.current = PathImpl.this.nodes().iterator();
                this.next = PathImpl.this.relationships().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.current.hasNext();
            }

            @Override
            public PropertyContainer next() {
                try {
                    PropertyContainer propertyContainer = this.current.next();
                    return propertyContainer;
                }
                finally {
                    Iterator<? extends PropertyContainer> temp = this.current;
                    this.current = this.next;
                    this.next = temp;
                }
            }

            @Override
            public void remove() {
                this.next.remove();
            }
        };
    }

    @Override
    public int length() {
        return this.path.length;
    }

    public int hashCode() {
        if (this.path.length == 0) {
            return this.start.hashCode();
        }
        return Arrays.hashCode(this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Path) {
            Path other2 = (Path)obj;
            return this.start.equals(other2.startNode()) && Iterators.iteratorsEqual(this.relationships().iterator(), other2.relationships().iterator());
        }
        return false;
    }

    @Override
    public String toString() {
        return Paths.defaultPathToString(this);
    }

    public static final class Builder {
        private final Builder previous;
        private final Node start;
        private final Relationship relationship;
        private final int size;

        public Builder(Node start) {
            if (start == null) {
                throw new NullPointerException();
            }
            this.start = start;
            this.previous = null;
            this.relationship = null;
            this.size = 0;
        }

        private Builder(Builder prev, Relationship rel) {
            this.start = prev.start;
            this.previous = prev;
            this.relationship = rel;
            this.size = prev.size + 1;
        }

        public Node getStartNode() {
            return this.start;
        }

        public Path build() {
            return new PathImpl(this, null);
        }

        public Builder push(Relationship relationship) {
            if (relationship == null) {
                throw new NullPointerException();
            }
            return new Builder(this, relationship);
        }

        public Path build(Builder other2) {
            return new PathImpl(this, other2);
        }

        public String toString() {
            if (this.previous == null) {
                return this.start.toString();
            }
            return PathImpl.relToString(this.relationship) + ":" + this.previous.toString();
        }
    }
}

