/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.util.Validator;

@Deprecated
public class Args {
    private static final char OPTION_METADATA_DELIMITER = ':';
    private static final Function<String, Option<String>> DEFAULT_OPTION_PARSER = from2 -> {
        int metadataStartIndex = from2.indexOf(58);
        return metadataStartIndex == -1 ? new Option(from2, null) : new Option(from2.substring(0, metadataStartIndex), from2.substring(metadataStartIndex + 1));
    };
    private final String[] args;
    private final String[] flags;
    private final Map<String, List<Option<String>>> map = new HashMap<String, List<Option<String>>>();
    private final List<String> orphans = new ArrayList<String>();

    @Deprecated
    public static ArgsParser withFlags(String ... flags) {
        return new ArgsParser(flags);
    }

    @Deprecated
    public static Args parse(String ... args) {
        return Args.withFlags(new String[0]).parse(args);
    }

    private Args(String[] flags, String[] args) {
        this(DEFAULT_OPTION_PARSER, flags, args);
    }

    private Args(Function<String, Option<String>> optionParser, String[] flags, String[] args) {
        this.flags = flags;
        this.args = args;
        this.parseArgs(optionParser, args);
    }

    @Deprecated
    public Args(Map<String, String> source) {
        this(DEFAULT_OPTION_PARSER, source);
    }

    @Deprecated
    public Args(Function<String, Option<String>> optionParser, Map<String, String> source) {
        this.flags = new String[0];
        this.args = null;
        for (Map.Entry<String, String> entry : source.entrySet()) {
            this.put(optionParser, entry.getKey(), entry.getValue());
        }
    }

    @Deprecated
    public String[] source() {
        return this.args;
    }

    @Deprecated
    public Map<String, String> asMap() {
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (Map.Entry<String, List<Option<String>>> entry : this.map.entrySet()) {
            Option value2 = (Option)Iterables.firstOrNull((Iterable)entry.getValue());
            result2.put(entry.getKey(), value2 != null ? (String)value2.value() : null);
        }
        return result2;
    }

    @Deprecated
    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    @Deprecated
    public boolean hasNonNull(String key) {
        List<Option<String>> values2 = this.map.get(key);
        return values2 != null && !values2.isEmpty();
    }

    @Deprecated
    private String getSingleOptionOrNull(String key) {
        List<Option<String>> values2 = this.map.get(key);
        if (values2 == null || values2.isEmpty()) {
            return null;
        }
        if (values2.size() > 1) {
            throw new IllegalArgumentException("There are multiple values for '" + key + "'");
        }
        return values2.get(0).value();
    }

    @Deprecated
    public String get(String key) {
        return this.getSingleOptionOrNull(key);
    }

    @Deprecated
    public String get(String key, String defaultValue) {
        String value2 = this.getSingleOptionOrNull(key);
        return value2 != null ? value2 : defaultValue;
    }

    @Deprecated
    public String get(String key, String defaultValueIfNotFound, String defaultValueIfNoValue) {
        String value2 = this.getSingleOptionOrNull(key);
        if (value2 != null) {
            return value2;
        }
        return this.map.containsKey(key) ? defaultValueIfNoValue : defaultValueIfNotFound;
    }

    @Deprecated
    public Number getNumber(String key, Number defaultValue) {
        String value2 = this.getSingleOptionOrNull(key);
        return value2 != null ? (Number)Double.valueOf(value2) : (Number)defaultValue;
    }

    @Deprecated
    public long getDuration(String key, long defaultValueInMillis) {
        String value2 = this.getSingleOptionOrNull(key);
        return value2 != null ? TimeUtil.parseTimeMillis.apply(value2) : defaultValueInMillis;
    }

    @Deprecated
    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    @Deprecated
    public Boolean getBoolean(String key, Boolean defaultValueIfNotSpecified) {
        return this.getBoolean(key, defaultValueIfNotSpecified, Boolean.TRUE);
    }

    @Deprecated
    public Boolean getBoolean(String key, Boolean defaultValueIfNotSpecified, Boolean defaultValueIfSpecifiedButNoValue) {
        String value2 = this.getSingleOptionOrNull(key);
        if (value2 != null) {
            return Boolean.valueOf(value2);
        }
        return this.map.containsKey(key) ? defaultValueIfSpecifiedButNoValue : defaultValueIfNotSpecified;
    }

    @Deprecated
    public <T extends Enum<T>> T getEnum(Class<T> enumClass, String key, T defaultValue) {
        String raw2 = this.getSingleOptionOrNull(key);
        if (raw2 == null) {
            return defaultValue;
        }
        for (Enum candidate : (Enum[])enumClass.getEnumConstants()) {
            if (!candidate.name().equals(raw2)) continue;
            return (T)candidate;
        }
        throw new IllegalArgumentException("No enum instance '" + raw2 + "' in " + enumClass.getName());
    }

    @Deprecated
    public List<String> orphans() {
        return new ArrayList<String>(this.orphans);
    }

    @Deprecated
    public String[] orphansAsArray() {
        return this.orphans.toArray(new String[0]);
    }

    @Deprecated
    public String[] asArgs() {
        ArrayList<String> list2 = new ArrayList<String>(this.orphans.size());
        for (String string2 : this.orphans) {
            String quote = string2.contains(" ") ? " " : "";
            list2.add(quote + string2 + quote);
        }
        for (Map.Entry entry : this.map.entrySet()) {
            for (Option option : (List)entry.getValue()) {
                String key = option.metadata != null ? (String)entry.getKey() + ':' + option.metadata() : (String)entry.getKey();
                String value2 = (String)option.value();
                String quote = key.contains(" ") || value2 != null && value2.contains(" ") ? " " : "";
                list2.add(quote + (key.length() > 1 ? "--" : "-") + key + (value2 != null ? "=" + value2 + quote : ""));
            }
        }
        return list2.toArray(new String[0]);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String arg : this.asArgs()) {
            builder.append(builder.length() > 0 ? " " : "").append(arg);
        }
        return builder.toString();
    }

    private static boolean isOption(String arg) {
        return arg.startsWith("-") && arg.length() > 1;
    }

    private boolean isFlag(String arg) {
        return ArrayUtil.contains(this.flags, arg);
    }

    private static boolean isBoolean(String value2) {
        return "true".equalsIgnoreCase(value2) || "false".equalsIgnoreCase(value2);
    }

    private static String stripOption(String arg) {
        while (!arg.isEmpty() && arg.charAt(0) == '-') {
            arg = arg.substring(1);
        }
        return arg;
    }

    private void parseArgs(Function<String, Option<String>> optionParser, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (Args.isOption(arg)) {
                String value2;
                int equalIndex = (arg = Args.stripOption(arg)).indexOf(61);
                if (equalIndex != -1) {
                    String key = arg.substring(0, equalIndex);
                    value2 = arg.substring(equalIndex + 1);
                    if (value2.isEmpty()) continue;
                    this.put(optionParser, key, value2);
                    continue;
                }
                if (this.isFlag(arg)) {
                    int nextIndex = i + 1;
                    String string2 = value2 = nextIndex < args.length ? args[nextIndex] : null;
                    if (Args.isBoolean(value2)) {
                        i = nextIndex;
                        this.put(optionParser, arg, Boolean.valueOf(value2).toString());
                        continue;
                    }
                    this.put(optionParser, arg, null);
                    continue;
                }
                int nextIndex = i + 1;
                value2 = nextIndex < args.length ? args[nextIndex] : null;
                String string3 = value2 = value2 == null || Args.isOption(value2) ? null : value2;
                if (value2 != null) {
                    i = nextIndex;
                }
                this.put(optionParser, arg, value2);
                continue;
            }
            this.orphans.add(arg);
        }
    }

    private void put(Function<String, Option<String>> optionParser, String key, String value2) {
        Option<String> option = optionParser.apply(key);
        List values2 = this.map.computeIfAbsent(option.value(), k -> new ArrayList());
        values2.add(new Option(value2, option.metadata()));
    }

    @Deprecated
    public static String jarUsage(Class<?> main2, String ... params2) {
        StringBuilder usage = new StringBuilder("USAGE: java [-cp ...] ");
        try {
            String jar = main2.getProtectionDomain().getCodeSource().getLocation().getPath();
            usage.append("-jar ").append(jar);
        }
        catch (Exception exception) {
            // empty catch block
        }
        usage.append(' ').append(main2.getCanonicalName());
        for (String param2 : params2) {
            usage.append(' ').append(param2);
        }
        return usage.toString();
    }

    @Deprecated
    public static String[] splitLongLine(String description, int maxLength) {
        ArrayList<String> lines2 = new ArrayList<String>();
        while (description.length() > 0) {
            String line = description.substring(0, Math.min(maxLength, description.length()));
            int position2 = line.indexOf("\n");
            if (position2 > -1) {
                line = description.substring(0, position2);
                lines2.add(line);
                if ((description = description.substring(position2)).length() <= 0) continue;
                description = description.substring(1);
                continue;
            }
            position2 = description.length() > maxLength ? Args.findSpaceBefore(description, maxLength) : description.length();
            line = description.substring(0, position2);
            lines2.add(line);
            description = description.substring(position2);
        }
        return lines2.toArray(new String[0]);
    }

    private static int findSpaceBefore(String description, int position2) {
        while (!Character.isWhitespace(description.charAt(position2))) {
            --position2;
        }
        return position2 + 1;
    }

    @Deprecated
    @SafeVarargs
    public final <T> T interpretOption(String key, Function<String, T> defaultValue, Function<String, T> converter, Validator<T> ... validators) {
        T value2;
        if (!this.has(key)) {
            value2 = defaultValue.apply(key);
        } else {
            String stringValue = this.get(key);
            value2 = converter.apply(stringValue);
        }
        return this.validated(value2, validators);
    }

    @Deprecated
    @SafeVarargs
    public final <T> Collection<T> interpretOptions(String key, Function<String, T> defaultValue, Function<String, T> converter, Validator<T> ... validators) {
        Collection<Option<T>> options = this.interpretOptionsWithMetadata(key, defaultValue, converter, validators);
        ArrayList<T> values2 = new ArrayList<T>(options.size());
        for (Option<T> option : options) {
            values2.add(option.value());
        }
        return values2;
    }

    @Deprecated
    @SafeVarargs
    public final <T> Collection<Option<T>> interpretOptionsWithMetadata(String key, Function<String, T> defaultValue, Function<String, T> converter, Validator<T> ... validators) {
        ArrayList<Option<T>> values2 = new ArrayList<Option<T>>();
        if (!this.hasNonNull(key)) {
            T defaultItem = defaultValue.apply(key);
            if (defaultItem != null) {
                values2.add(new Option(this.validated(defaultItem, validators), null));
            }
        } else {
            for (Option<String> option : this.map.get(key)) {
                String stringValue = option.value();
                values2.add(new Option(this.validated(converter.apply(stringValue), validators), option.metadata()));
            }
        }
        return values2;
    }

    @Deprecated
    @SafeVarargs
    public final <T> T interpretOrphan(int index, Function<String, T> defaultValue, Function<String, T> converter, Validator<T> ... validators) {
        T value2;
        assert (index >= 0);
        if (index >= this.orphans.size()) {
            value2 = defaultValue.apply("argument at index " + index);
        } else {
            String stringValue = this.orphans.get(index);
            value2 = converter.apply(stringValue);
        }
        return this.validated(value2, validators);
    }

    @SafeVarargs
    private final <T> T validated(T value2, Validator<T> ... validators) {
        if (value2 != null) {
            for (Validator<T> validator : validators) {
                validator.validate(value2);
            }
        }
        return value2;
    }

    @Deprecated
    public static class Option<T> {
        private final T value;
        private final String metadata;

        private Option(T value2, String metadata) {
            this.value = value2;
            this.metadata = metadata;
        }

        public T value() {
            return this.value;
        }

        public String metadata() {
            return this.metadata;
        }

        public String toString() {
            return "Option[" + this.value + (this.metadata != null ? ", " + this.metadata : "") + "]";
        }
    }

    @Deprecated
    public static class ArgsParser {
        private final String[] flags;

        private ArgsParser(String ... flags) {
            this.flags = Objects.requireNonNull(flags);
        }

        public Args parse(String ... arguments2) {
            return new Args(this.flags, arguments2);
        }
    }
}

