/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Function;

@Deprecated
public abstract class ArrayUtil {
    @Deprecated
    public static final ArrayEquality DEFAULT_ARRAY_EQUALITY = new ArrayEquality(){

        @Override
        public boolean typeEquals(Class<?> firstType, Class<?> otherType) {
            return firstType == otherType;
        }

        @Override
        public boolean itemEquals(Object lhs, Object rhs) {
            return lhs == rhs || lhs != null && lhs.equals(rhs);
        }
    };
    @Deprecated
    public static final ArrayEquality BOXING_AWARE_ARRAY_EQUALITY = new ArrayEquality(){

        @Override
        public boolean typeEquals(Class<?> firstType, Class<?> otherType) {
            return this.boxedType(firstType) == this.boxedType(otherType);
        }

        private Class<?> boxedType(Class<?> type) {
            if (!type.isPrimitive()) {
                return type;
            }
            if (type.equals(Boolean.TYPE)) {
                return Boolean.class;
            }
            if (type.equals(Byte.TYPE)) {
                return Byte.class;
            }
            if (type.equals(Short.TYPE)) {
                return Short.class;
            }
            if (type.equals(Character.TYPE)) {
                return Character.class;
            }
            if (type.equals(Integer.TYPE)) {
                return Integer.class;
            }
            if (type.equals(Long.TYPE)) {
                return Long.class;
            }
            if (type.equals(Float.TYPE)) {
                return Float.class;
            }
            if (type.equals(Double.TYPE)) {
                return Double.class;
            }
            throw new IllegalArgumentException("Oops, forgot to include a primitive type " + type);
        }

        @Override
        public boolean itemEquals(Object lhs, Object rhs) {
            return lhs == rhs || lhs != null && lhs.equals(rhs);
        }
    };

    @Deprecated
    public static int hashCode(Object array) {
        int length2;
        assert (array.getClass().isArray()) : array + " is not an array";
        int result2 = length2 = Array.getLength(array);
        for (int i = 0; i < length2; ++i) {
            result2 = 31 * result2 + Array.get(array, i).hashCode();
        }
        return result2;
    }

    @Deprecated
    public static boolean equals(Object firstArray, Object otherArray) {
        return ArrayUtil.equals(firstArray, otherArray, DEFAULT_ARRAY_EQUALITY);
    }

    @Deprecated
    public static boolean equals(Object firstArray, Object otherArray, ArrayEquality equality) {
        int length2;
        assert (firstArray.getClass().isArray()) : firstArray + " is not an array";
        assert (otherArray.getClass().isArray()) : otherArray + " is not an array";
        if (equality.typeEquals(firstArray.getClass().getComponentType(), otherArray.getClass().getComponentType()) && (length2 = Array.getLength(firstArray)) == Array.getLength(otherArray)) {
            for (int i = 0; i < length2; ++i) {
                if (equality.itemEquals(Array.get(firstArray, i), Array.get(otherArray, i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static Object clone(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).clone();
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).clone();
        }
        if (array instanceof byte[]) {
            return ((byte[])array).clone();
        }
        if (array instanceof short[]) {
            return ((short[])array).clone();
        }
        if (array instanceof char[]) {
            return ((char[])array).clone();
        }
        if (array instanceof int[]) {
            return ((int[])array).clone();
        }
        if (array instanceof long[]) {
            return ((long[])array).clone();
        }
        if (array instanceof float[]) {
            return ((float[])array).clone();
        }
        if (array instanceof double[]) {
            return ((double[])array).clone();
        }
        throw new IllegalArgumentException("Not an array type: " + array.getClass());
    }

    @Deprecated
    public static <T> int missing(T[] array, T[] contains2) {
        int missing = 0;
        for (T check2 : contains2) {
            if (ArrayUtil.contains(array, check2)) continue;
            ++missing;
        }
        return missing;
    }

    @Deprecated
    public static <T> boolean containsAll(T[] array, T[] contains2) {
        for (T check2 : contains2) {
            if (ArrayUtil.contains(array, check2)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static <T> boolean contains(T[] array, T contains2) {
        return ArrayUtil.contains(array, array.length, contains2);
    }

    @Deprecated
    public static <T> boolean contains(T[] array, int arrayLength, T contains2) {
        for (int i = 0; i < arrayLength; ++i) {
            T item = array[i];
            if (!ArrayUtil.nullSafeEquals(item, contains2)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static <T> boolean nullSafeEquals(T first, T other2) {
        return first == null ? first == other2 : first.equals(other2);
    }

    @Deprecated
    public static <T> T[] union(T[] first, T[] other2) {
        if (first == null || other2 == null) {
            return first == null ? other2 : first;
        }
        int missing = ArrayUtil.missing(first, other2);
        if (missing == 0) {
            return first;
        }
        T[] union2 = Arrays.copyOf(first, first.length + missing);
        int cursor = first.length;
        for (T candidate : other2) {
            if (ArrayUtil.contains(first, candidate)) continue;
            union2[cursor++] = candidate;
            --missing;
        }
        assert (missing == 0);
        return union2;
    }

    @Deprecated
    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    @Deprecated
    public static <T> String join(T[] items, String delimiter) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            builder.append(i > 0 ? delimiter : "").append(items[i]);
        }
        return builder.toString();
    }

    @Deprecated
    public static <FROM, TO> TO[] map(FROM[] from2, Function<FROM, TO> transformer, Class<TO> toClass) {
        Object[] result2 = (Object[])Array.newInstance(toClass, from2.length);
        for (int i = 0; i < from2.length; ++i) {
            result2[i] = transformer.apply(from2[i]);
        }
        return result2;
    }

    @Deprecated
    public static <T> T[] concat(T first, T ... additional) {
        Object[] result2 = (Object[])Array.newInstance(additional.getClass().getComponentType(), additional.length + 1);
        result2[0] = first;
        System.arraycopy(additional, 0, result2, 1, additional.length);
        return result2;
    }

    @Deprecated
    public static <T> T[] concat(T[] initial, T ... additional) {
        Object[] result2 = (Object[])Array.newInstance(additional.getClass().getComponentType(), initial.length + additional.length);
        System.arraycopy(initial, 0, result2, 0, initial.length);
        System.arraycopy(additional, 0, result2, initial.length, additional.length);
        return result2;
    }

    public static <T> T[] concatArrays(T[] initial, T[] ... additional) {
        int length2 = initial.length;
        for (T[] array : additional) {
            length2 += array.length;
        }
        T[] result2 = Arrays.copyOf(initial, length2);
        int offset = initial.length;
        for (T[] array : additional) {
            System.arraycopy(array, 0, result2, offset, array.length);
            offset += array.length;
        }
        return result2;
    }

    @Deprecated
    @SafeVarargs
    public static <T> T[] array(T ... varargs2) {
        return varargs2;
    }

    @Deprecated
    public static <T> T lastOf(T[] array) {
        return array[array.length - 1];
    }

    @Deprecated
    public static <T> int indexOf(T[] array, T item) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public static <T> T[] without(T[] source, T ... toRemove) {
        Object[] result2 = (Object[])source.clone();
        int length2 = result2.length;
        for (T candidate : toRemove) {
            int index = ArrayUtil.indexOf(result2, candidate);
            if (index == -1) continue;
            if (index + 1 < length2) {
                result2[index] = result2[length2 - 1];
            }
            --length2;
        }
        return length2 == result2.length ? result2 : Arrays.copyOf(result2, length2);
    }

    @Deprecated
    public static <T> void reverse(T[] array) {
        int low = 0;
        int high = array.length - 1;
        while (high - low > 0) {
            T lowItem = array[low];
            array[low] = array[high];
            array[high] = lowItem;
            ++low;
            --high;
        }
    }

    private ArrayUtil() {
    }

    @Deprecated
    public static interface ArrayEquality {
        public boolean typeEquals(Class<?> var1, Class<?> var2);

        public boolean itemEquals(Object var1, Object var2);
    }
}

