/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;

public class TransactionTemplate {
    private final GraphDatabaseService gds;
    private final Monitor monitor;
    private final int retries;
    private final long backoff;
    private final Predicate<Throwable> retryPredicate;

    public TransactionTemplate() {
        this((GraphDatabaseService)Proxy.newProxyInstance(GraphDatabaseService.class.getClassLoader(), new Class[]{GraphDatabaseService.class}, (proxy, method, args) -> {
            throw new IllegalArgumentException("You need to call 'with(GraphDatabaseService)' on the template in order to use it");
        }), new Monitor.Adapter(), 0, 0L, ex -> !Error.class.isInstance(ex) && !TransactionTerminatedException.class.isInstance(ex));
    }

    public TransactionTemplate(GraphDatabaseService gds, Monitor monitor, int retries, long backoff, Predicate<Throwable> retryPredicate) {
        Objects.requireNonNull(gds);
        Objects.requireNonNull(monitor);
        if (retries < 0) {
            throw new IllegalArgumentException("Number of retries must be greater than or equal to 0");
        }
        if (backoff < 0L) {
            throw new IllegalArgumentException("Backoff time must be a positive number");
        }
        Objects.requireNonNull(retryPredicate);
        this.gds = gds;
        this.monitor = monitor;
        this.retries = retries;
        this.backoff = backoff;
        this.retryPredicate = retryPredicate;
    }

    public TransactionTemplate with(GraphDatabaseService gds) {
        return new TransactionTemplate(gds, this.monitor, this.retries, this.backoff, this.retryPredicate);
    }

    public TransactionTemplate retries(int retries) {
        return new TransactionTemplate(this.gds, this.monitor, retries, this.backoff, this.retryPredicate);
    }

    public TransactionTemplate backoff(long backoff, TimeUnit unit) {
        return new TransactionTemplate(this.gds, this.monitor, this.retries, unit.toMillis(backoff), this.retryPredicate);
    }

    public TransactionTemplate monitor(Monitor monitor) {
        return new TransactionTemplate(this.gds, monitor, this.retries, this.backoff, this.retryPredicate);
    }

    public TransactionTemplate retryOn(Predicate<Throwable> retryPredicate) {
        return new TransactionTemplate(this.gds, this.monitor, this.retries, this.backoff, retryPredicate);
    }

    public void execute(Consumer<Transaction> txConsumer) {
        this.execute((Transaction transaction) -> {
            txConsumer.accept((Transaction)transaction);
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(Function<Transaction, T> txFunction) throws TransactionFailureException {
        int retriesLeft = this.retries;
        while (true) {
            try (Transaction tx = this.gds.beginTx();){
                Transaction result2 = txFunction.apply(tx);
                tx.success();
                Transaction t = result2;
                return (T)t;
            }
            catch (Throwable ex) {
                this.monitor.failure(ex);
                Throwable txEx = ex;
                if (this.retryPredicate.test(ex)) {
                    try {
                        Thread.sleep(this.backoff);
                    }
                    catch (InterruptedException e) {
                        TransactionFailureException interrupted = new TransactionFailureException("Interrupted", e);
                        this.monitor.failed(interrupted);
                        throw interrupted;
                    }
                    if (retriesLeft != 0) {
                        --retriesLeft;
                        this.monitor.retrying();
                        continue;
                    }
                }
                this.monitor.failed(txEx);
                throw new TransactionFailureException("Failed", txEx);
            }
            break;
        }
    }

    public static interface Monitor {
        public void failure(Throwable var1);

        public void failed(Throwable var1);

        public void retrying();

        public static class Adapter
        implements Monitor {
            @Override
            public void failure(Throwable ex) {
            }

            @Override
            public void failed(Throwable ex) {
            }

            @Override
            public void retrying() {
            }
        }
    }
}

