/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public abstract class IndexQuery {
    private final int propertyKeyId;

    public static ExistsPredicate exists(int propertyKeyId) {
        return new ExistsPredicate(propertyKeyId);
    }

    public static ExactPredicate exact(int propertyKeyId, Object value2) {
        return new ExactPredicate(propertyKeyId, value2);
    }

    public static RangePredicate<?> range(int propertyKeyId, Number from2, boolean fromInclusive, Number to2, boolean toInclusive) {
        return new NumberRangePredicate(propertyKeyId, from2 == null ? null : Values.numberValue(from2), fromInclusive, to2 == null ? null : Values.numberValue(to2), toInclusive);
    }

    public static RangePredicate<?> range(int propertyKeyId, String from2, boolean fromInclusive, String to2, boolean toInclusive) {
        return new TextRangePredicate(propertyKeyId, from2 == null ? null : Values.stringValue(from2), fromInclusive, to2 == null ? null : Values.stringValue(to2), toInclusive);
    }

    public static <VALUE extends Value> RangePredicate<?> range(int propertyKeyId, VALUE from2, boolean fromInclusive, VALUE to2, boolean toInclusive) {
        if (from2 == null && to2 == null) {
            throw new IllegalArgumentException("Cannot create RangePredicate without at least one bound");
        }
        ValueGroup valueGroup = from2 != null ? from2.valueGroup() : to2.valueGroup();
        switch (valueGroup) {
            case NUMBER: {
                return new NumberRangePredicate(propertyKeyId, (NumberValue)from2, fromInclusive, (NumberValue)to2, toInclusive);
            }
            case TEXT: {
                return new TextRangePredicate(propertyKeyId, (TextValue)from2, fromInclusive, (TextValue)to2, toInclusive);
            }
            case GEOMETRY: {
                PointValue pFrom = (PointValue)from2;
                PointValue pTo = (PointValue)to2;
                CoordinateReferenceSystem crs = pFrom != null ? pFrom.getCoordinateReferenceSystem() : pTo.getCoordinateReferenceSystem();
                return new GeometryRangePredicate(propertyKeyId, crs, pFrom, fromInclusive, pTo, toInclusive);
            }
        }
        return new RangePredicate<VALUE>(propertyKeyId, valueGroup, from2, fromInclusive, to2, toInclusive);
    }

    public static RangePredicate<?> range(int propertyKeyId, ValueGroup valueGroup) {
        if (valueGroup == ValueGroup.GEOMETRY) {
            throw new IllegalArgumentException("Cannot create GeometryRangePredicate without a specified CRS");
        }
        return new RangePredicate<Object>(propertyKeyId, valueGroup, null, true, null, true);
    }

    public static RangePredicate<?> range(int propertyKeyId, CoordinateReferenceSystem crs) {
        return new GeometryRangePredicate(propertyKeyId, crs, null, true, null, true);
    }

    public static StringPrefixPredicate stringPrefix(int propertyKeyId, TextValue prefix) {
        return new StringPrefixPredicate(propertyKeyId, prefix);
    }

    public static StringContainsPredicate stringContains(int propertyKeyId, TextValue contains2) {
        return new StringContainsPredicate(propertyKeyId, contains2);
    }

    public static StringSuffixPredicate stringSuffix(int propertyKeyId, TextValue suffix) {
        return new StringSuffixPredicate(propertyKeyId, suffix);
    }

    public static ValueTuple asValueTuple(ExactPredicate ... query) {
        Value[] values2 = new Value[query.length];
        for (int i = 0; i < query.length; ++i) {
            values2[i] = query[i].value();
        }
        return ValueTuple.of(values2);
    }

    protected IndexQuery(int propertyKeyId) {
        this.propertyKeyId = propertyKeyId;
    }

    public abstract IndexQueryType type();

    public final boolean equals(Object other2) {
        return EqualsBuilder.reflectionEquals((Object)this, other2, new String[0]);
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, false);
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public final int propertyKeyId() {
        return this.propertyKeyId;
    }

    public abstract boolean acceptsValue(Value var1);

    public boolean acceptsValueAt(PropertyCursor property) {
        return this.acceptsValue(property.propertyValue());
    }

    public abstract ValueGroup valueGroup();

    public static final class StringSuffixPredicate
    extends StringPredicate {
        private final TextValue suffix;

        StringSuffixPredicate(int propertyKeyId, TextValue suffix) {
            super(propertyKeyId);
            this.suffix = this.asUTF8StringValue(suffix);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringSuffix;
        }

        @Override
        public boolean acceptsValue(Value value2) {
            return Values.isTextValue(value2) && ((TextValue)value2).endsWith(this.suffix);
        }

        public TextValue suffix() {
            return this.suffix;
        }
    }

    public static final class StringContainsPredicate
    extends StringPredicate {
        private final TextValue contains;

        StringContainsPredicate(int propertyKeyId, TextValue contains2) {
            super(propertyKeyId);
            this.contains = this.asUTF8StringValue(contains2);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringContains;
        }

        @Override
        public boolean acceptsValue(Value value2) {
            return Values.isTextValue(value2) && ((TextValue)value2).contains(this.contains);
        }

        public TextValue contains() {
            return this.contains;
        }
    }

    public static final class StringPrefixPredicate
    extends StringPredicate {
        private final TextValue prefix;

        StringPrefixPredicate(int propertyKeyId, TextValue prefix) {
            super(propertyKeyId);
            this.prefix = this.asUTF8StringValue(prefix);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringPrefix;
        }

        @Override
        public boolean acceptsValue(Value value2) {
            return Values.isTextValue(value2) && ((TextValue)value2).startsWith(this.prefix);
        }

        public TextValue prefix() {
            return this.prefix;
        }
    }

    public static abstract class StringPredicate
    extends IndexQuery {
        StringPredicate(int propertyKeyId) {
            super(propertyKeyId);
        }

        @Override
        public ValueGroup valueGroup() {
            return ValueGroup.TEXT;
        }

        protected TextValue asUTF8StringValue(TextValue in2) {
            if (in2 instanceof UTF8StringValue) {
                return in2;
            }
            return Values.utf8Value(in2.stringValue().getBytes(StandardCharsets.UTF_8));
        }
    }

    public static final class TextRangePredicate
    extends RangePredicate<TextValue> {
        TextRangePredicate(int propertyKeyId, TextValue from2, boolean fromInclusive, TextValue to2, boolean toInclusive) {
            super(propertyKeyId, ValueGroup.TEXT, from2, fromInclusive, to2, toInclusive);
        }

        public String from() {
            return this.from == null ? null : ((TextValue)this.from).stringValue();
        }

        public String to() {
            return this.to == null ? null : ((TextValue)this.to).stringValue();
        }
    }

    public static final class NumberRangePredicate
    extends RangePredicate<NumberValue> {
        NumberRangePredicate(int propertyKeyId, NumberValue from2, boolean fromInclusive, NumberValue to2, boolean toInclusive) {
            super(propertyKeyId, ValueGroup.NUMBER, from2, fromInclusive, to2, toInclusive);
        }

        public Number from() {
            return this.from == null ? (Number)null : (Number)((NumberValue)this.from).asObject();
        }

        public Number to() {
            return this.to == null ? (Number)null : (Number)((NumberValue)this.to).asObject();
        }
    }

    public static final class GeometryRangePredicate
    extends RangePredicate<PointValue> {
        private final CoordinateReferenceSystem crs;

        GeometryRangePredicate(int propertyKeyId, CoordinateReferenceSystem crs, PointValue from2, boolean fromInclusive, PointValue to2, boolean toInclusive) {
            super(propertyKeyId, ValueGroup.GEOMETRY, from2, fromInclusive, to2, toInclusive);
            this.crs = crs;
        }

        @Override
        public boolean acceptsValue(Value value2) {
            PointValue point;
            if (value2 == null) {
                return false;
            }
            if (value2 instanceof PointValue && (point = (PointValue)value2).getCoordinateReferenceSystem().equals(this.crs)) {
                Boolean within = point.withinRange((PointValue)this.from, this.fromInclusive, (PointValue)this.to, this.toInclusive);
                return within == null ? false : within;
            }
            return false;
        }

        public CoordinateReferenceSystem crs() {
            return this.crs;
        }

        public PointValue from() {
            return (PointValue)this.from;
        }

        public PointValue to() {
            return (PointValue)this.to;
        }

        @Override
        public boolean isRegularOrder() {
            return false;
        }
    }

    public static class RangePredicate<T extends Value>
    extends IndexQuery {
        protected final T from;
        protected final boolean fromInclusive;
        protected final T to;
        protected final boolean toInclusive;
        protected final ValueGroup valueGroup;

        RangePredicate(int propertyKeyId, ValueGroup valueGroup, T from2, boolean fromInclusive, T to2, boolean toInclusive) {
            super(propertyKeyId);
            this.valueGroup = valueGroup;
            this.from = from2;
            this.fromInclusive = fromInclusive;
            this.to = to2;
            this.toInclusive = toInclusive;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.range;
        }

        @Override
        public boolean acceptsValue(Value value2) {
            if (value2 == null || value2 == Values.NO_VALUE) {
                return false;
            }
            if (value2.valueGroup() == this.valueGroup) {
                int compare;
                if (this.from != null && ((compare = Values.COMPARATOR.compare(value2, (Value)this.from)) < 0 || !this.fromInclusive && compare == 0)) {
                    return false;
                }
                if (this.to != null) {
                    compare = Values.COMPARATOR.compare(value2, (Value)this.to);
                    return compare <= 0 && (this.toInclusive || compare != 0);
                }
                return true;
            }
            return false;
        }

        @Override
        public ValueGroup valueGroup() {
            return this.valueGroup;
        }

        public Value fromValue() {
            return this.from == null ? Values.NO_VALUE : this.from;
        }

        public Value toValue() {
            return this.to == null ? Values.NO_VALUE : this.to;
        }

        public boolean fromInclusive() {
            return this.fromInclusive;
        }

        public boolean toInclusive() {
            return this.toInclusive;
        }

        public boolean isRegularOrder() {
            return true;
        }
    }

    public static final class ExactPredicate
    extends IndexQuery {
        private final Value exactValue;

        ExactPredicate(int propertyKeyId, Object value2) {
            super(propertyKeyId);
            this.exactValue = value2 instanceof Value ? (Value)value2 : Values.of(value2);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.exact;
        }

        @Override
        public boolean acceptsValue(Value value2) {
            return this.exactValue.equals(value2);
        }

        @Override
        public ValueGroup valueGroup() {
            return this.exactValue.valueGroup();
        }

        public Value value() {
            return this.exactValue;
        }
    }

    public static final class ExistsPredicate
    extends IndexQuery {
        ExistsPredicate(int propertyKeyId) {
            super(propertyKeyId);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.exists;
        }

        @Override
        public boolean acceptsValue(Value value2) {
            return value2 != null && value2 != Values.NO_VALUE;
        }

        @Override
        public boolean acceptsValueAt(PropertyCursor property) {
            return true;
        }

        @Override
        public ValueGroup valueGroup() {
            return ValueGroup.UNKNOWN;
        }
    }

    public static enum IndexQueryType {
        exists,
        exact,
        range,
        stringPrefix,
        stringSuffix,
        stringContains;

    }
}

