/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public abstract class ConstraintValidationException
extends KernelException {
    protected final ConstraintDescriptor constraint;

    protected ConstraintValidationException(ConstraintDescriptor constraint, Phase phase, String subject) {
        super(phase.getStatus(), "%s does not satisfy %s.", subject, constraint.prettyPrint(SchemaUtil.idTokenNameLookup));
        this.constraint = constraint;
    }

    protected ConstraintValidationException(ConstraintDescriptor constraint, Phase phase, String subject, Throwable failure) {
        super(phase.getStatus(), failure, "%s does not satisfy %s: %s", subject, constraint.prettyPrint(SchemaUtil.idTokenNameLookup), failure.getMessage());
        this.constraint = constraint;
    }

    @Override
    public abstract String getUserMessage(TokenNameLookup var1);

    public ConstraintDescriptor constraint() {
        return this.constraint;
    }

    public static enum Phase {
        VERIFICATION(Status.Statement.ConstraintVerificationFailed),
        VALIDATION(Status.Schema.ConstraintValidationFailed);

        private final Status status;

        private Phase(Status status) {
            this.status = status;
        }

        public Status getStatus() {
            return this.status;
        }
    }
}

